/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager.check;

import java.io.FileNotFoundException;
import java.util.concurrent.TimeUnit;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.Task;
import org.jboss.aerogear.test.container.manager.JBossManagerConfiguration;
import org.jboss.aerogear.test.container.spacelift.JBossCLI;

public class DomainStartedCheckTask
extends Task<Object, Boolean> {
    private JBossManagerConfiguration configuration = new JBossManagerConfiguration();

    public DomainStartedCheckTask configuration(JBossManagerConfiguration configuration) {
        if (configuration != null) {
            this.configuration = configuration;
        }
        return this;
    }

    protected Boolean process(Object input) throws Exception {
        ProcessResult domainServersStartInitiatedResult = null;
        this.configuration.validate();
        try {
            domainServersStartInitiatedResult = (ProcessResult)((JBossCLI)Spacelift.task(JBossCLI.class)).environment("JBOSS_HOME", this.configuration.getJBossHome()).user(this.configuration.getUser()).password(this.configuration.getPassword()).connect().cliCommand("/host=" + this.configuration.getDomainMasterHostName() + ":read-children-names(child-type=server)").execute().reexecuteEvery(5L, TimeUnit.SECONDS).until(this.configuration.getDomainStartTimeout(), TimeUnit.SECONDS, (ExecutionCondition)new ExecutionCondition<ProcessResult>(){

                public boolean satisfiedBy(ProcessResult result) throws ExecutionException {
                    int runningDomainServers = 0;
                    boolean success = false;
                    for (String line : result.output()) {
                        if (!line.contains("outcome") || !line.contains("success")) continue;
                        success = true;
                        break;
                    }
                    if (!success) {
                        return false;
                    }
                    for (String domainServer : DomainStartedCheckTask.this.configuration.getDomainServers()) {
                        for (String line : result.output()) {
                            if (!line.contains(domainServer)) continue;
                            ++runningDomainServers;
                        }
                    }
                    return runningDomainServers == DomainStartedCheckTask.this.configuration.getDomainServers().size();
                }
            });
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                throw ex;
            }
            if (ex.getCause() instanceof JBossCLI.NotExecutableScriptException) {
                throw ex;
            }
            domainServersStartInitiatedResult = null;
        }
        return domainServersStartInitiatedResult != null && domainServersStartInitiatedResult.exitValue() == 0;
    }
}

