/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.spacelift;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.ProcessResult;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.os.CommandTool;

public class JBossCLI
extends Task<Object, ProcessResult> {
    private final Map<String, String> environment = new HashMap<String, String>();
    private String user;
    private String password;
    private File file;
    private String controller;
    private boolean connect = false;
    private List<String> command = new ArrayList<String>();
    private List<Integer> exitCodes = new ArrayList<Integer>();

    public JBossCLI environment(String key, String value) {
        if (key != null && value != null) {
            this.environment.put(key, value);
        }
        return this;
    }

    public JBossCLI environment(Map<String, String> environment) {
        if (environment != null) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                if (entry == null) continue;
                this.environment(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public JBossCLI user(String user) {
        this.user = user;
        return this;
    }

    public JBossCLI password(String password) {
        this.password = password;
        return this;
    }

    public JBossCLI file(String file) {
        this.file = new File(file);
        return this;
    }

    public JBossCLI file(File file) {
        this.file = file;
        return this;
    }

    public JBossCLI controller(String controller) {
        this.controller = controller;
        return this;
    }

    public JBossCLI connect() {
        this.connect = true;
        return this;
    }

    public JBossCLI cliCommand(String ... command) {
        this.command.addAll(Arrays.asList(command));
        return this;
    }

    public JBossCLI shouldExitWith(Integer ... exitCodes) {
        this.exitCodes.addAll(Arrays.asList(exitCodes));
        return this;
    }

    protected ProcessResult process(Object input) throws Exception {
        CommandTool jbossCliTool = this.getJBossCliTool();
        if (this.controller != null) {
            jbossCliTool.parameter((CharSequence)("--controller=" + this.controller));
        }
        if (this.connect) {
            jbossCliTool.parameter((CharSequence)"--connect");
        }
        if (this.file != null) {
            jbossCliTool.parameter((CharSequence)("--file=" + this.file.getAbsolutePath()));
        }
        if (this.command.size() == 1) {
            jbossCliTool.parameter((CharSequence)("--command=" + this.command.get(0)));
        }
        if (this.command.size() > 1) {
            jbossCliTool.parameter((CharSequence)("--commands=" + this.getCommands()));
        }
        if (this.user != null) {
            jbossCliTool.parameter((CharSequence)("--user=" + this.user));
        }
        if (this.password != null) {
            jbossCliTool.parameter((CharSequence)("--password=" + this.password));
        }
        jbossCliTool.shouldExitWith(this.exitCodes.toArray(new Integer[this.exitCodes.size()]));
        ProcessResult processResult = (ProcessResult)jbossCliTool.execute().await();
        return processResult;
    }

    private String getCommands() {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String command : this.command) {
            sb.append(delim).append(command);
            delim = ",";
        }
        return sb.toString();
    }

    private CommandTool getJBossCliTool() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            File jbossScript = new File(this.environment.get("JBOSS_HOME"), "/bin/jboss-cli.bat");
            this.validateScript(jbossScript);
            return ((CommandTool)Spacelift.task(CommandTool.class)).command(new CommandBuilder((CharSequence)"cmd.exe")).parameters(new CharSequence[]{"/C", jbossScript.getAbsolutePath()}).addEnvironment(this.environment);
        }
        File jbossScript = new File(this.environment.get("JBOSS_HOME"), "/bin/jboss-cli.sh");
        this.validateScript(jbossScript);
        return ((CommandTool)Spacelift.task(CommandTool.class)).command(new CommandBuilder((CharSequence)jbossScript.getAbsolutePath())).addEnvironment(this.environment);
    }

    private void validateScript(File jbossScript) throws Exception {
        if (!jbossScript.exists()) {
            throw new FileNotFoundException(jbossScript.getAbsolutePath() + " does not exist.");
        }
        if (!jbossScript.canExecute()) {
            throw new NotExecutableScriptException(jbossScript + " is not executable.");
        }
    }

    public static class NotExecutableScriptException
    extends Exception {
        private static final long serialVersionUID = -2281993207167380102L;

        public NotExecutableScriptException() {
        }

        public NotExecutableScriptException(String message, Throwable cause) {
            super(message, cause);
        }

        public NotExecutableScriptException(String message) {
            super(message);
        }

        public NotExecutableScriptException(Throwable cause) {
            super(cause);
        }
    }
}

