/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.iharder.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.aerogear.unifiedpush.JavaSender;
import org.jboss.aerogear.unifiedpush.message.MessageResponseCallback;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;
import org.jboss.aerogear.unifiedpush.utils.ValidationUtils;

public class SenderClient
implements JavaSender {
    private static final Logger logger = Logger.getLogger(SenderClient.class.getName());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String serverURL;

    public SenderClient(String rootServerURL) {
        this.setServerURL(rootServerURL);
    }

    public SenderClient() {
    }

    protected String buildUrl() {
        if (ValidationUtils.isEmpty(this.serverURL)) {
            throw new IllegalStateException("server can not be null");
        }
        return this.serverURL + "rest/sender/";
    }

    @Override
    public void send(UnifiedMessage unifiedMessage, MessageResponseCallback callback) {
        Map<String, Object> payloadObject = this.prepareMessage(unifiedMessage);
        String jsonString = this.toJSONString(payloadObject);
        this.submitPayload(this.buildUrl(), jsonString, unifiedMessage.getPushApplicationId(), unifiedMessage.getMasterSecret(), callback);
    }

    @Override
    public void send(UnifiedMessage unifiedMessage) {
        this.send(unifiedMessage, null);
    }

    private Map<String, Object> prepareMessage(UnifiedMessage unifiedMessage) {
        LinkedHashMap<String, Object> payloadObject = new LinkedHashMap<String, Object>();
        if (!ValidationUtils.isEmpty(unifiedMessage.getAliases())) {
            payloadObject.put("alias", unifiedMessage.getAliases());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getCategories())) {
            payloadObject.put("categories", unifiedMessage.getCategories());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getDeviceType())) {
            payloadObject.put("deviceType", unifiedMessage.getDeviceType());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getVariants())) {
            payloadObject.put("variants", unifiedMessage.getVariants());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getAttributes())) {
            payloadObject.put("message", unifiedMessage.getAttributes());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getSimplePush())) {
            payloadObject.put("simple-push", unifiedMessage.getSimplePush());
        }
        return payloadObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPayload(String url, String jsonPayloadObject, String pushApplicationId, String masterSecret, MessageResponseCallback callback) {
        String credentials = pushApplicationId + ":" + masterSecret;
        int statusCode = 0;
        HttpURLConnection httpURLConnection = null;
        try {
            String encoded = Base64.encodeBytes((byte[])credentials.getBytes(UTF_8));
            httpURLConnection = this.post(url, encoded, jsonPayloadObject);
            statusCode = httpURLConnection.getResponseCode();
            logger.info(String.format("HTTP Response code from UnifiedPush Server: %s", statusCode));
            if (this.isRedirect(statusCode)) {
                String redirectURL = httpURLConnection.getHeaderField("Location");
                logger.info(String.format("Performing redirect to '%s'", redirectURL));
                this.submitPayload(redirectURL, jsonPayloadObject, pushApplicationId, masterSecret, callback);
            } else if (callback != null) {
                callback.onComplete(statusCode);
            }
        }
        catch (Exception e) {
            logger.severe("Send did not succeed: " + e.getMessage());
            if (callback != null) {
                callback.onError(e);
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection post(String url, String encodedCredentials, String jsonPayloadObject) throws IOException {
        if (url == null || encodedCredentials == null || jsonPayloadObject == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        byte[] bytes = jsonPayloadObject.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Authorization", "Basic " + encodedCredentials);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestMethod("POST");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }

    private boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 303;
    }

    private String toJSONString(Object value) {
        ObjectMapper om = new ObjectMapper();
        String stringPayload = null;
        try {
            stringPayload = om.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode JSON payload");
        }
        return stringPayload;
    }

    @Override
    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public void setServerURL(String serverURL) {
        if (ValidationUtils.isEmpty(serverURL)) {
            throw new IllegalStateException("server can not be null");
        }
        if (!serverURL.endsWith("/")) {
            serverURL = serverURL.concat("/");
        }
        this.serverURL = serverURL;
    }
}

