/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.iharder.Base64;
import org.jboss.aerogear.unifiedpush.PushSender;
import org.jboss.aerogear.unifiedpush.http.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.message.MessageResponseCallback;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;
import org.jboss.aerogear.unifiedpush.model.ProxyConfig;
import org.jboss.aerogear.unifiedpush.model.TrustStoreConfig;
import org.jboss.aerogear.unifiedpush.utils.PushConfiguration;
import org.jboss.aerogear.unifiedpush.utils.ValidationUtils;

public class DefaultPushSender
implements PushSender {
    private static final Logger logger = Logger.getLogger(DefaultPushSender.class.getName());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final PushConfiguration pushConfiguration;
    private final ProxyConfig proxy;
    private final TrustStoreConfig customTrustStore;

    private DefaultPushSender(Builder builder) {
        this.pushConfiguration = builder.pushConfiguration;
        this.proxy = builder.proxy;
        this.customTrustStore = builder.customTrustStore;
    }

    public static Builder withRootServerURL(String rootServerURL) {
        return new Builder(rootServerURL);
    }

    public static Builder withConfig(String location) {
        try {
            return new Builder(PushConfiguration.read(location));
        }
        catch (IOException e) {
            logger.severe("Could not read config file : " + e);
            return null;
        }
    }

    protected String buildUrl() {
        if (ValidationUtils.isEmpty(this.getServerURL())) {
            throw new IllegalStateException("server can not be null");
        }
        return this.getServerURL() + "rest/sender/";
    }

    @Override
    public void send(UnifiedMessage unifiedMessage, MessageResponseCallback callback) {
        String jsonString = unifiedMessage.getObject().toJsonString();
        this.submitPayload(this.buildUrl(), jsonString, this.pushConfiguration.getPushApplicationId(), this.pushConfiguration.getMasterSecret(), callback, new ArrayList<String>());
    }

    @Override
    public void send(UnifiedMessage unifiedMessage) {
        this.send(unifiedMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPayload(String url, String jsonPayloadObject, String pushApplicationId, String masterSecret, MessageResponseCallback callback, List<String> redirectUrls) {
        if (redirectUrls.contains(url)) {
            throw new IllegalStateException("The site contains an infinite redirect loop! Duplicate url: " + url);
        }
        redirectUrls.add(url);
        String credentials = pushApplicationId + ':' + masterSecret;
        HttpURLConnection httpURLConnection = null;
        try {
            String encoded = Base64.encodeBytes((byte[])credentials.getBytes(UTF_8));
            httpURLConnection = (HttpURLConnection)HttpRequestUtil.post(url, encoded, jsonPayloadObject, UTF_8, this.proxy, this.customTrustStore);
            int statusCode = httpURLConnection.getResponseCode();
            logger.info(String.format("HTTP Response code from UnifiedPush Server: %s", statusCode));
            if (DefaultPushSender.isRedirect(statusCode)) {
                String redirectURL = httpURLConnection.getHeaderField("Location");
                logger.info(String.format("Performing redirect to '%s'", redirectURL));
                this.submitPayload(redirectURL, jsonPayloadObject, pushApplicationId, masterSecret, callback, redirectUrls);
            } else if (callback != null) {
                callback.onComplete(statusCode);
            }
        }
        catch (Exception e) {
            logger.severe("Send did not succeed: " + e.getMessage());
            if (callback != null) {
                callback.onError(e);
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 303;
    }

    @Override
    public String getServerURL() {
        return this.pushConfiguration.getServerUrl();
    }

    @Override
    public ProxyConfig getProxy() {
        return this.proxy;
    }

    @Override
    public TrustStoreConfig getCustomTrustStore() {
        return this.customTrustStore;
    }

    @Override
    public String getPushApplicationId() {
        return this.pushConfiguration.getPushApplicationId();
    }

    @Override
    public String getMasterSecret() {
        return this.pushConfiguration.getMasterSecret();
    }

    public static class Builder {
        private PushConfiguration pushConfiguration;
        private ProxyConfig proxy;
        private TrustStoreConfig customTrustStore;

        private Builder(String rootServerURL) {
            this.pushConfiguration = new PushConfiguration();
            if (ValidationUtils.isEmpty(rootServerURL)) {
                throw new IllegalStateException("server can not be null");
            }
            this.pushConfiguration.setServerUrl(!rootServerURL.endsWith("/") ? rootServerURL + '/' : rootServerURL);
        }

        private Builder(PushConfiguration pushConfiguration) {
            this.pushConfiguration = pushConfiguration;
        }

        public Builder pushApplicationId(String pushApplicationId) {
            this.pushConfiguration.setPushApplicationId(pushApplicationId);
            return this;
        }

        public Builder masterSecret(String masterSecret) {
            this.pushConfiguration.setMasterSecret(masterSecret);
            return this;
        }

        public Builder customTrustStore(String trustStorePath, String trustStoreType, String trustStorePassword) {
            this.customTrustStore = new TrustStoreConfig(trustStorePath, trustStoreType, trustStorePassword);
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyHost(proxyHost);
            this.proxy.setProxyPort(proxyPort);
            return this;
        }

        public Builder proxyUser(String proxyUser) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyUser(proxyUser);
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyPassword(proxyPassword);
            return this;
        }

        public Builder proxyType(Proxy.Type proxyType) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyType(proxyType);
            return this;
        }

        public DefaultPushSender build() {
            return new DefaultPushSender(this);
        }
    }
}

