/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.KeyStore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.aerogear.unifiedpush.ca.TrustStoreManagerService;
import org.jboss.aerogear.unifiedpush.model.ProxyConfig;
import org.jboss.aerogear.unifiedpush.model.TrustStoreConfig;

public class HttpRequestUtil {
    private HttpRequestUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLConnection post(String url, String encodedCredentials, String jsonPayloadObject, Charset charset, ProxyConfig proxy, TrustStoreConfig customTrustStore) throws Exception {
        if (url == null || encodedCredentials == null || jsonPayloadObject == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        byte[] bytes = jsonPayloadObject.getBytes(charset);
        URLConnection conn = HttpRequestUtil.getConnection(url, proxy);
        if (customTrustStore != null && customTrustStore.getTrustStorePath() != null && conn instanceof HttpsURLConnection) {
            KeyStore trustStore = TrustStoreManagerService.getInstance().getTrustStoreManager().loadTrustStore(customTrustStore.getTrustStorePath(), customTrustStore.getTrustStoreType(), customTrustStore.getTrustStorePassword());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, tmf.getTrustManagers(), null);
            SSLSocketFactory sslSocketFactory = ctx.getSocketFactory();
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
        }
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        ((HttpURLConnection)conn).setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Authorization", "Basic " + encodedCredentials);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json, text/plain");
        conn.setRequestProperty("aerogear-sender", "AeroGear Java Sender");
        ((HttpURLConnection)conn).setRequestMethod("POST");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    private static URLConnection getConnection(String url, final ProxyConfig proxy) throws IOException {
        URLConnection conn = null;
        if (proxy != null && proxy.getProxyUser() != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxy.getProxyUser(), proxy.getProxyPassword().toCharArray());
                }
            });
        }
        if (proxy != null) {
            Proxy thisProxy = new Proxy(proxy.getProxyType(), new InetSocketAddress(proxy.getProxyHost(), proxy.getProxyPort()));
            conn = new URL(url).openConnection(thisProxy);
        } else {
            conn = new URL(url).openConnection();
        }
        return conn;
    }
}

