/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.aerogear.unifiedpush.message.Config;
import org.jboss.aerogear.unifiedpush.message.Criteria;
import org.jboss.aerogear.unifiedpush.message.Message;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.message.apns.APNs;
import org.jboss.aerogear.unifiedpush.message.windows.BadgeType;
import org.jboss.aerogear.unifiedpush.message.windows.DurationType;
import org.jboss.aerogear.unifiedpush.message.windows.TileType;
import org.jboss.aerogear.unifiedpush.message.windows.ToastType;
import org.jboss.aerogear.unifiedpush.message.windows.Type;
import org.jboss.aerogear.unifiedpush.message.windows.Windows;

public class UnifiedMessage {
    private final UnifiedPushMessage unifiedPushMessage = new UnifiedPushMessage();
    private final MessageBuilder message;
    private final CriteriaBuilder criteria;
    private final ConfigBuilder config;

    public static MessageBuilder withMessage() {
        return new Builder().message();
    }

    public static CriteriaBuilder withCriteria() {
        return new Builder().criteria();
    }

    public static ConfigBuilder withConfig() {
        return new Builder().config();
    }

    private UnifiedMessage(Builder builder) {
        this.criteria = builder.criteriaBuilder;
        this.config = builder.configBuilder;
        this.message = builder.messageBuilder;
    }

    public MessageBuilder getMessage() {
        return this.message;
    }

    public CriteriaBuilder getCriteria() {
        return this.criteria;
    }

    public ConfigBuilder getConfig() {
        return this.config;
    }

    public UnifiedPushMessage getObject() {
        if (this.message != null) {
            this.unifiedPushMessage.setMessage(this.message.getObject());
        }
        if (this.config != null) {
            this.unifiedPushMessage.setConfig(this.config.getObject());
        }
        if (this.criteria != null) {
            this.unifiedPushMessage.setCriteria(this.criteria.getObject());
        }
        return this.unifiedPushMessage;
    }

    public static class ConfigBuilder {
        private final Builder builder;
        private final Config config = new Config();

        public ConfigBuilder(Builder builder) {
            this.builder = builder;
        }

        public ConfigBuilder timeToLive(int seconds) {
            this.config.setTimeToLive(seconds);
            return this;
        }

        protected Config getObject() {
            return this.config;
        }

        public MessageBuilder message() {
            if (this.builder.messageBuilder == null) {
                this.builder.messageBuilder = new MessageBuilder(this.builder);
            }
            return this.builder.messageBuilder;
        }

        public CriteriaBuilder criteria() {
            if (this.builder.criteriaBuilder == null) {
                this.builder.criteriaBuilder = new CriteriaBuilder(this.builder);
            }
            return this.builder.criteriaBuilder;
        }

        public UnifiedMessage build() {
            return this.builder.build();
        }
    }

    public static class MessageBuilder {
        private final Builder builder;
        private final Message message = new Message();
        private WindowsBuilder windowsBuilder;
        private ApnsBuilder apnsBuilder;

        public MessageBuilder(Builder builder) {
            this.builder = builder;
        }

        public MessageBuilder alert(String message) {
            this.message.setAlert(message);
            return this;
        }

        public MessageBuilder sound(String sound) {
            this.message.setSound(sound);
            return this;
        }

        public MessageBuilder badge(String badge) {
            this.message.setBadge(Integer.valueOf(badge).intValue());
            return this;
        }

        public MessageBuilder simplePush(String version) {
            this.message.setSimplePush(MessageBuilder.fixVersion(version));
            return this;
        }

        public MessageBuilder userData(String key, String value) {
            this.message.getUserData().put(key, value);
            return this;
        }

        public MessageBuilder userData(Map<String, Object> userDataMap) {
            this.message.setUserData(userDataMap);
            return this;
        }

        public CriteriaBuilder criteria() {
            if (this.builder.criteriaBuilder == null) {
                this.builder.criteriaBuilder = new CriteriaBuilder(this.builder);
            }
            return this.builder.criteriaBuilder;
        }

        public ConfigBuilder config() {
            if (this.builder.configBuilder == null) {
                this.builder.configBuilder = new ConfigBuilder(this.builder);
            }
            return this.builder.configBuilder;
        }

        public WindowsBuilder windows() {
            if (this.windowsBuilder == null) {
                this.windowsBuilder = new WindowsBuilder(this);
            }
            return this.windowsBuilder;
        }

        public ApnsBuilder apns() {
            if (this.apnsBuilder == null) {
                this.apnsBuilder = new ApnsBuilder(this);
            }
            return this.apnsBuilder;
        }

        private static String fixVersion(String version) {
            if (version != null && !version.startsWith("version=")) {
                version = "version=" + version;
            }
            return version;
        }

        public UnifiedMessage build() {
            return this.builder.build();
        }

        protected Message getObject() {
            return this.message;
        }

        public static class ApnsBuilder {
            private final MessageBuilder messageBuilder;
            private final APNs apns = new APNs();

            public ApnsBuilder(MessageBuilder builder) {
                this.messageBuilder = builder;
            }

            public ApnsBuilder contentAvailable() {
                this.apns.setContentAvailable(true);
                return this;
            }

            public ApnsBuilder actionCategory(String actionCategory) {
                this.apns.setActionCategory(actionCategory);
                return this;
            }

            public ApnsBuilder action(String action) {
                this.apns.setAction(action);
                return this;
            }

            public ApnsBuilder title(String title) {
                this.apns.setTitle(title);
                return this;
            }

            public ApnsBuilder localizedTitleKey(String localizedTitleKey) {
                this.apns.setLocalizedTitleKey(localizedTitleKey);
                return this;
            }

            public ApnsBuilder localizedTitleArguments(String[] localizedTitleArguments) {
                this.apns.setLocalizedTitleArguments(localizedTitleArguments);
                return this;
            }

            public ApnsBuilder urlArgs(String[] urlArgs) {
                this.apns.setUrlArgs(urlArgs);
                return this;
            }

            public MessageBuilder build() {
                this.messageBuilder.message.setApns(this.apns);
                return this.messageBuilder;
            }
        }

        public static class WindowsBuilder {
            private final MessageBuilder messageBuilder;
            private final Windows windows = new Windows();

            public WindowsBuilder(MessageBuilder builder) {
                this.messageBuilder = builder;
            }

            public WindowsBuilder type(Type type) {
                this.windows.setType(type);
                return this;
            }

            public WindowsBuilder raw() {
                this.windows.setType(Type.raw);
                return this;
            }

            public WindowsBuilder badgeType(BadgeType badgeType) {
                this.windows.setType(Type.badge);
                this.windows.setBadge(badgeType);
                return this;
            }

            public WindowsBuilder tileType(TileType tileType) {
                this.windows.setType(Type.tile);
                this.windows.setTileType(tileType);
                return this;
            }

            public WindowsBuilder durationType(DurationType durationType) {
                this.windows.setDuration(durationType);
                return this;
            }

            public WindowsBuilder toastType(ToastType toastType) {
                this.windows.setType(Type.toast);
                this.windows.setToastType(toastType);
                return this;
            }

            public WindowsBuilder images(List<String> images) {
                this.windows.setImages(images);
                return this;
            }

            public WindowsBuilder textFields(List<String> textFields) {
                this.windows.setTextFields(textFields);
                return this;
            }

            public WindowsBuilder page(String page) {
                this.windows.setPage(page);
                return this;
            }

            public MessageBuilder build() {
                this.messageBuilder.message.setWindows(this.windows);
                return this.messageBuilder;
            }
        }
    }

    public static class CriteriaBuilder {
        private final Builder builder;
        private final Criteria criteria = new Criteria();

        public CriteriaBuilder(Builder builder) {
            this.builder = builder;
        }

        public CriteriaBuilder aliases(List<String> aliases) {
            this.criteria.setAliases(aliases);
            return this;
        }

        public CriteriaBuilder aliases(String ... aliases) {
            return this.aliases(new ArrayList<String>(Arrays.asList(aliases)));
        }

        public CriteriaBuilder variants(List<String> variants) {
            this.criteria.setVariants(variants);
            return this;
        }

        public CriteriaBuilder variants(String ... variants) {
            return this.variants(new ArrayList<String>(Arrays.asList(variants)));
        }

        public CriteriaBuilder categories(Set<String> categories) {
            this.criteria.setCategories(new ArrayList<String>(categories));
            return this;
        }

        public CriteriaBuilder categories(String ... categories) {
            return this.categories(new HashSet<String>(Arrays.asList(categories)));
        }

        public CriteriaBuilder deviceType(List<String> deviceType) {
            this.criteria.setDeviceTypes(deviceType);
            return this;
        }

        public CriteriaBuilder deviceType(String ... deviceType) {
            return this.deviceType(new ArrayList<String>(Arrays.asList(deviceType)));
        }

        public MessageBuilder message() {
            if (this.builder.messageBuilder == null) {
                this.builder.messageBuilder = new MessageBuilder(this.builder);
            }
            return this.builder.messageBuilder;
        }

        public ConfigBuilder config() {
            if (this.builder.configBuilder == null) {
                this.builder.configBuilder = new ConfigBuilder(this.builder);
            }
            return this.builder.configBuilder;
        }

        public UnifiedMessage build() {
            return this.builder.build();
        }

        public Criteria getObject() {
            return this.criteria;
        }
    }

    public static class Builder {
        private MessageBuilder messageBuilder;
        private CriteriaBuilder criteriaBuilder;
        private ConfigBuilder configBuilder;

        public CriteriaBuilder criteria() {
            if (this.criteriaBuilder == null) {
                this.criteriaBuilder = new CriteriaBuilder(this);
            }
            return this.criteriaBuilder;
        }

        public MessageBuilder message() {
            if (this.messageBuilder == null) {
                this.messageBuilder = new MessageBuilder(this);
            }
            return this.messageBuilder;
        }

        public ConfigBuilder config() {
            if (this.configBuilder == null) {
                this.configBuilder = new ConfigBuilder(this);
            }
            return this.configBuilder;
        }

        public UnifiedMessage build() {
            return new UnifiedMessage(this);
        }
    }
}

