/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.aerogear.unifiedpush.Client;

public class AsyncClient
implements Client {
    private static final Logger logger = Logger.getLogger(AsyncClient.class.getName());

    @Override
    public void post(Map<String, ? extends Object> json, String url, String pushApplicationId, String masterSecret) {
        String payload = this.transformJSON(json);
        this.submitPayload(url, payload, pushApplicationId, masterSecret);
    }

    @Override
    public void post(Map<String, ? extends Object> json, List<String> clientIdentifiers, String url, String pushApplicationId, String masterSecret) {
        LinkedHashMap<String, Object> selectedPayloadObject = new LinkedHashMap<String, Object>();
        selectedPayloadObject.put("alias", clientIdentifiers);
        selectedPayloadObject.put("message", json);
        String payload = this.transformJSON(selectedPayloadObject);
        this.submitPayload(url, payload, pushApplicationId, masterSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPayload(String url, String jsonPayloadObject, String pushApplicationId, String masterSecret) {
        AsyncHttpClient asyncHttpClient = new AsyncHttpClient();
        try {
            Realm realm = new Realm.RealmBuilder().setPrincipal(pushApplicationId).setPassword(masterSecret).setUsePreemptiveAuth(true).setScheme(Realm.AuthScheme.BASIC).build();
            Response response = (Response)((AsyncHttpClient.BoundRequestBuilder)asyncHttpClient.preparePost(url).addHeader("Accept", "application/json").addHeader("Content-type", "application/json").setRealm(realm)).setBody(jsonPayloadObject).execute().get();
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                logger.severe("Receiving status code: " + statusCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            asyncHttpClient.closeAsynchronously();
        }
    }

    private String transformJSON(Object value) {
        ObjectMapper om = new ObjectMapper();
        String stringPayload = null;
        try {
            stringPayload = om.writeValueAsString(value);
        }
        catch (Exception e) {
            new IllegalStateException("Failed to encode JSON payload");
        }
        return stringPayload;
    }
}

