/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.resteasy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.aerogear.unifiedpush.Client;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public class RestEasyClient
implements Client {
    private static final Logger logger = Logger.getLogger(RestEasyClient.class.getName());

    @Override
    public void post(Map<String, ? extends Object> json, String url, String pushApplicationID, String masterSecret) {
        this.submitPayload(url, json, pushApplicationID, masterSecret);
    }

    @Override
    public void post(Map<String, ? extends Object> json, List<String> clientIdentifiers, String url, String pushApplicationID, String masterSecret) {
        LinkedHashMap<String, Object> selectedPayloadObject = new LinkedHashMap<String, Object>();
        selectedPayloadObject.put("alias", clientIdentifiers);
        selectedPayloadObject.put("message", json);
        this.submitPayload(url, selectedPayloadObject, pushApplicationID, masterSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPayload(String url, Map<String, ? extends Object> json, String pushApplicationID, String masterSecret) {
        URL parsedUrl = null;
        try {
            parsedUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        HttpHost targetHost = new HttpHost(parsedUrl.getHost(), parsedUrl.getPort(), "http");
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(pushApplicationID, masterSecret));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient, (HttpContext)localContext);
        ClientRequest clientRequest = new ClientRequest(url, (ClientExecutor)clientExecutor);
        clientRequest.accept(MediaType.APPLICATION_JSON_TYPE);
        clientRequest.body(MediaType.APPLICATION_JSON_TYPE, json);
        ClientResponse resp = null;
        try {
            resp = clientRequest.post(String.class);
            int statusCode = resp.getStatus();
            if (statusCode != 200) {
                logger.severe("Receiving status code: " + statusCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (resp != null) {
                resp.releaseConnection();
            }
        }
    }
}

