"use strict";!function(){var app=angular.module("upsConsole",["ngResource","ngNewRouter","ngAnimate","ngIdle","ui.bootstrap","patternfly.notification","patternfly.select","angular-c3","ngClipboard"]),auth={};angular.element(document).ready(function(){var keycloak=new Keycloak("config/admin-ui-keycloak.json");auth.loggedIn=!1,keycloak.init({onLoad:"login-required"}).success(function(){auth.loggedIn=!0,auth.keycloak=keycloak,auth.logout=function(){auth.loggedIn=!1,auth.keycloak=null,window.location=keycloak.authServerUrl+"/realms/aerogear/tokens/logout?redirect_uri="+window.location.href},app.factory("Auth",function(){return auth}),angular.bootstrap(document,["upsConsole"])}).error(function(){window.location.reload()})}),app.run(function($rootScope){$rootScope.$rootScope=$rootScope}),app.factory("Auth",function(){return auth});var appConfig={logDebugEnabled:!1,idleDuration:300,idleWarningDuration:30,keepaliveInterval:5};app.provider("appConfig",function(){return{set:function(settings){angular.extend(appConfig,settings)},$get:function(){return appConfig}}}),app.factory("authInterceptor",function($q,Auth){return{request:function(config){var deferred=$q.defer();return"rest/sender"===config.url||"rest/registry/device/importer"===config.url?config:(Auth.keycloak&&Auth.keycloak.token&&Auth.keycloak.updateToken(5).success(function(){config.headers=config.headers||{},config.headers.Authorization="Bearer "+Auth.keycloak.token,deferred.resolve(config)}).error(function(){window.location.reload()}),deferred.promise)}}}),app.config(function($httpProvider){$httpProvider.interceptors.push("authInterceptor")}),app.config(function($logProvider,appConfigProvider){var appConfig=appConfigProvider.$get();$logProvider.debugEnabled(appConfig.logDebugEnabled)}),app.factory("docsLinks",function($http){var result={};return $http.get("docs-links.json").then(function(response){angular.extend(result,response.data)}),result}),app.config(function(ngClipProvider){ngClipProvider.setPath("img/ZeroClipboard.swf")})}(),angular.module("upsConsole").config(function($provide){$provide.decorator("$resource",function($delegate){return function(url,paramDefaults,actions){var args=Array.prototype.slice.call(arguments),wrappedResource={},originalActions={},actionsWithoutFunctions=args[2]={};Object.keys(actions).forEach(function(methodName){var method=actions[methodName];originalActions[methodName]=method,angular.isFunction(method)||(actionsWithoutFunctions[methodName]=method)});var originalResource=$delegate.apply($delegate,args);return Object.keys(originalActions).forEach(function(methodName){var method=originalActions[methodName];wrappedResource[methodName]=angular.isFunction(method)?method:function(){return originalResource[methodName].apply(originalResource,arguments).$promise}}),wrappedResource}})}),angular.module("upsConsole").controller("RouteController",function($router){$router.config([{path:"/",component:"home"},{path:"/welcome",component:"welcome"},{path:"/wizard/create-app",component:"wizard01CreateApp"},{path:"/wizard/add-variant",component:"wizard02AddVariant"},{path:"/wizard/register-device",component:"wizard03RegisterDevice"},{path:"/wizard/send-push-notification",component:"wizard04SendPushNotification"},{path:"/wizard/setup-sender",component:"wizard05SetupSender"},{path:"/wizard/done",component:"wizard06Done"},{path:"/app/:app/:tab",component:"appDetail"},{path:"/links-check",component:"linksCheck"}])}),angular.module("upsConsole").controller("AppController",function($rootScope,$scope,Auth,$http,$interval,$timeout,$log,appConfig,dashboardEndpoint){function getUsername(){return Auth.keycloak.idTokenParsed.preferred_username}function updateStats(){dashboardEndpoint.totals().then(function(data){self.stats=data})}function updateWarnings(){dashboardEndpoint.warnings().then(function(warnings){self.warnings=warnings})}var self=this;this.config=appConfig,this.warnings=[],this.username=getUsername(),$scope.$watch(getUsername,function(newValue){self.username=newValue}),this.logout=function(){Auth.logout()},this.goToAccountManagement=function(){window.location=Auth.keycloak.authServerUrl+"/realms/aerogear/account?referrer=unified-push-server-js"},this.havePendingRequests=function(){return $http.pendingRequests.some(function(config){return"GET"!==config.method?!0:void 0})},this.stats={},updateStats(),$scope.$on("upsUpdateStats",updateStats),$scope.$on("upsApplicationCreated",updateStats),$scope.$on("upsApplicationDeleted",updateStats),updateWarnings(),$interval(updateWarnings,3e4),$scope.$on("upsNotificationSent",function(){$timeout(updateWarnings,1500),$timeout(updateWarnings,5e3),$timeout(updateWarnings,1e4)})}),angular.module("upsConsole").controller("IdleController",function(Keepalive,Idle,$rootScope,$scope,$log,appConfig,Auth){var self=this;self.config=appConfig,Idle.watch(),self.idleCountdown=appConfig.idleWarningDuration+1,$rootScope.$on("KeepaliveResponse",function(){Auth.keycloak.updateToken(45).success(function(refreshed){$log.debug(refreshed?"token was successfully refreshed":"token is still valid")}).error(function(){$log.debug("failed to refresh the token, or the session has expired")})}),$rootScope.$on("IdleStart",function(){$log.debug("idleStart")}),$rootScope.$on("IdleWarn",function(){$log.debug("idleWarn"),$scope.$apply(function(){self.idleCountdown=self.idleCountdown-1})}),$rootScope.$on("IdleEnd",function(){$log.debug("idleEnd"),$scope.$apply(function(){self.idleCountdown=appConfig.idleWarningDuration+1})}),$rootScope.$on("IdleTimeout",function(){$log.debug("idleTimeout"),Auth.logout()})}).config(function(KeepaliveProvider,IdleProvider,appConfigProvider){var appConfig=appConfigProvider.$get();IdleProvider.idle(appConfig.idleDuration),IdleProvider.timeout(appConfig.idleWarningDuration),KeepaliveProvider.interval(appConfig.keepaliveInterval)}),angular.module("upsConsole").controller("HomeController",function($q,$modal,$router,$rootScope,applicationsEndpoint,dashboardEndpoint,appModal,Notifications){var self=this;this.apps=[],this.topNotifications=[],this.canActivate=function(){return this.currentPage=1,self.fetchNewPage(1).then(function(){return self.totalItems<1?($router.parent.navigate("/welcome"),!1):void 0})},this.activate=function(){dashboardEndpoint.latestActiveApps().then(function(data){self.topNotifications=data})},this.pageChanged=function(page){self.fetchNewPage(page)},this.fetchNewPage=function(page){return applicationsEndpoint.fetch(page).then(function(result){self.apps=result.apps,self.totalItems=result.totalItems})},this.changeName=function(app){var appClone=angular.extend({},app);appModal.editName(appClone).then(function(updatedApp){angular.extend(app,updatedApp),Notifications.success("The name of "+app.name+" application was successfully changed")}).catch(function(){"cancel"!=e&&Notifications.error("Failed to modify app "+app.name+": "+e)})},this.deleteApp=function(app){$modal.open({templateUrl:"dialogs/remove-app.html",controller:function($modalInstance,$scope){$scope.app=app,$scope.confirm=function(){applicationsEndpoint.delete({appId:app.pushApplicationID}).then(function(){return $rootScope.$broadcast("upsApplicationDeleted"),self.fetchNewPage(self.currentPage)}).then(function(){$modalInstance.close(),self.totalItems<1&&$router.parent.navigate("/welcome")})},$scope.dismiss=function(){$modalInstance.dismiss("cancel")}}})}}),angular.module("upsConsole").controller("WelcomeController",function($rootScope){this.activate=function(){$rootScope.$broadcast("upsUpdateStats")}}),angular.module("upsConsole").controller("AppDetailController",function($rootScope,$q,$routeParams,$modal,applicationsEndpoint,messageSenderEndpoint,metricsEndpoint,ContextProvider,Notifications){var self=this;this.app=null,this.notifications=null,this.tab=$routeParams.tab,this.contextPath=ContextProvider.contextPath(),this.canActivate=function(){return $q.all([applicationsEndpoint.getWithMetrics({appId:$routeParams.app}).then(function(app){self.app=app,app.variants.length||(self.tab="variants")}),metricsEndpoint.fetchApplicationMetrics($routeParams.app,null,1).then(function(data){self.notifications=data.pushMetrics})])},this.sendNotification=function(){$modal.open({templateUrl:"dialogs/send-push-notification.html",controller:function($scope,$modalInstance){$scope.app=self.app,$scope.pushData={message:{sound:"default",alert:"","simple-push":"version="+(new Date).getTime()},criteria:{}},$scope.send=function(){$scope.selectedVariants&&($scope.pushData.criteria.variants=$scope.selectedVariants),$scope.aliases&&($scope.pushData.criteria.alias=$scope.aliases.split(",")),$scope.deviceTypes&&($scope.pushData.criteria.deviceType=$scope.deviceTypes.split(",")),$scope.categories&&($scope.pushData.criteria.categories=$scope.categories.split(",")),messageSenderEndpoint(self.app.pushApplicationID,self.app.masterSecret).send({},$scope.pushData).then(function(){self.app.$messageCount+=1,self.notifications.unshift({submitDate:(new Date).getTime()}),$modalInstance.close(),$rootScope.$broadcast("upsNotificationSent",$scope.pushData,$scope.app),Notifications.success("Notification was successfully sent")}).catch(function(){Notifications.error("Failed to sent notification")})},$scope.cancel=function(){$modalInstance.dismiss()}}})}}),angular.module("upsConsole").controller("SenderController",function($modal,$scope,applicationsEndpoint,ContextProvider){var self=this;this.app=$scope.$parent.$parent.appDetail.app,this.contextPath=ContextProvider.contextPath(),this.renewMasterSecret=function(){$modal.open({templateUrl:"inline:renew-master-secret.html",controller:function($scope,$modalInstance){$scope.confirm=function(){applicationsEndpoint.reset({appId:self.app.pushApplicationID},function(application){self.app.masterSecret=application.masterSecret,$modalInstance.close(application)})},$scope.dismiss=function(){$modalInstance.dismiss("cancel")}}})}}),angular.module("upsConsole").controller("VariantsController",function($modal,variantModal,$scope,variantsEndpoint,Notifications){function splitByType(variants){return variants.sort(function(a,b){return a.type.localeCompare(b.type)}).reduce(function(variantList,variant){var type=variant.type.match(/^windows/)?"windows":variant.type,variantType=variantList[type]=variantList[type]||[];return variantType.push(variant),variantType.$deviceCount=(variantType.$deviceCount||0)+(variant.$deviceCount||0),variantType.$messageCount=(variantType.$messageCount||0)+(variant.$messageCount||0),variantList},{})}var self=this;this.app=$scope.$parent.$parent.appDetail.app,this.byType=splitByType(this.app.variants),this.add=function(){return variantModal.add(this.app).then(function(variant){variant.$deviceCount=0,variant.$messageCount=0,self.app.variants.push(variant),self.byType=splitByType(self.app.variants),Notifications.success("Variant "+variant.name+" successfully created")}).catch(function(){Notifications.error("Failed to create variant "+variant.name)})},this.edit=function(variant){var variantClone=angular.extend({},variant);return variantModal.edit(this.app,variantClone).then(function(updatedVariant){angular.extend(variant,updatedVariant),Notifications.success("Variant "+variant.name+" was successfully modified")}).catch(function(e){"cancel"!=e&&Notifications.error("Failed to modify variant "+variant.name+": "+e)})},this.editName=function(variant){var variantClone=angular.extend({},variant);return variantModal.editName(self.app,variantClone).then(function(updatedVariant){angular.extend(variant,updatedVariant),Notifications.success("The name of "+variant.name+" variant was successfully changed")}).catch(function(e){"cancel"!==e&&Notifications.error("Failed to modify variant "+variant.name+": "+e)})},this.delete=function(variant){$modal.open({templateUrl:"dialogs/remove-variant.html",controller:function($modalInstance,$scope){$scope.variant=variant,$scope.confirm=function(){variantsEndpoint.delete({appId:self.app.pushApplicationID,variantType:variant.type,variantId:variant.variantID}).then(function(){self.app.variants=self.app.variants.filter(function(v){return v!=variant}),self.byType=splitByType(self.app.variants),$modalInstance.close()})},$scope.dismiss=function(){$modalInstance.dismiss("cancel")}}})},this.getWarningsForVariant=function(warnings,variant){return warnings.filter(function(warning){return warning.variant.variantID==variant.variantID})}}),angular.module("upsConsole").controller("ActivityController",function($modal,variantModal,$scope,metricsEndpoint){function fetchMetrics(page,searchString){metricsEndpoint.fetchApplicationMetrics(self.app.pushApplicationID,searchString,page,self.perPage).then(function(data){self.metrics=data.pushMetrics,self.totalCount=data.totalItems,self.currentStart=self.perPage*(self.currentPage-1)+1,self.currentEnd=self.perPage*(self.currentPage-1)+self.metrics.length,self.metrics.forEach(function(metric){try{metric.$message=JSON.parse(metric.rawJsonMessage)}catch(err){console.log("failed to parse metric"),metric.$message={}}metric.variantInformations.forEach(function(variantInformation){variantInformation.$variant=getVariantByID(variantInformation.variantID)})})})}function getVariantByID(variantID){return self.app.variants.filter(function(variant){return variant.variantID==variantID})[0]}var self=this;this.app=$scope.$parent.$parent.appDetail.app,this.metrics=[],this.totalCount=0,this.currentPage=1,this.currentStart=0,this.currentEnd=0,this.perPage=10,this.searchString="",fetchMetrics(1,null),this.onPageChange=function(page){fetchMetrics(page,self.searchString)},$scope.$on("upsNotificationSent",function(){fetchMetrics(self.currentPage,self.searchString)}),$scope.$watch(function(){return self.searchString},function(){self.currentPage=1,fetchMetrics(self.currentPage,self.searchString)})}),angular.module("upsConsole").controller("AnalyticsController",function($scope,$q,metricsEndpoint,c3Factory){function updateAnalytics(){metricsEndpoint.fetchApplicationMetrics(self.app.pushApplicationID,null,1,6).then(function(data){self.metrics=data.pushMetrics.reverse(),self.totalCount=data.totalItems,self.receivers=data.receivers,self.appOpenedCounter=data.appOpenedCounter,self.appOpenedRate=100*data.appOpenedCounter/data.receivers||0,self.performance=[["Targeted Devices"],["Push Open"]],angular.forEach(self.metrics,function(pushMessage){pushMessage.message=JSON.parse(pushMessage.rawJsonMessage),self.performance[0].push(pushMessage.totalReceivers),self.performance[1].push(pushMessage.appOpenCounter)}),c3Factory.get("performance").then(function(chart){chart.load({columns:self.performance})})})}function getPlatform(variant){switch(variant.type){case"adm":return"Amazon";case"ios":return"iOS";case"simplePush":return"SimplePush";case"windows_mpns":return"Windows";case"windows_wns":return"Windows";case"android":return"Android";default:return variant.type}}var self=this;this.app=$scope.$parent.$parent.appDetail.app,this.metrics=[],this.totalCount=0,this.receivers=0,this.appOpenedCounter=0,this.appOpenedRate=0,this.platforms={},this.platformArray=[],this.performance=[["Targeted Devices"],["Push Open"]],updateAnalytics(),$scope.$on("upsNotificationSent",function(){updateAnalytics()}),angular.forEach(this.app.variants,function(variant){var platform=getPlatform(variant);self.platforms[platform]=(self.platforms[platform]||0)+parseInt(variant.$deviceCount)}),angular.forEach(self.platforms,function(value,key){self.platformArray.push([key,value])}),this.performanceChartConfig={axis:{rotated:!1,x:{type:"category",categories:["Message 01","Message 02","Message 03","Message 04","Message 05","Message 06"],tick:{outer:!1,format:function(d){var pushMessage=self.metrics[d];if(pushMessage){var alert=pushMessage.message.alert;return alert.length>15&&(alert=alert.substring(0,15)+"..."),alert}return"Message #"+d}}},y:{tick:{outer:!1,format:function(x){if(x!=Math.floor(x)){{d3.selectAll(".c3-axis-y g.tick").filter(function(){var text=d3.select(this).select("text").text();return+text===x}).style("opacity",0)}return""}return x}}}},color:{pattern:["#006e9c","#00a8e1","#3f9c35","#ec7a08","#cc0000"]},data:{columns:this.performance,type:"bar"},grid:{y:{show:!0}}},this.pushNetworksChartConfig={data:{colors:{iOS:"#006e9c",Android:"#00a8e1",Windows:"#969696"},columns:this.platformArray,type:"donut"},donut:{title:function(){return 1==self.app.$deviceCount?"1 Device":self.app.$deviceCount+" Devices"}}}}),angular.module("upsConsole").controller("Wizard01CreateAppController",function($rootScope,variantModal,$router,applicationsEndpoint,createAppWizard,Notifications){var self=this;this.application={},this.createApp=function(){applicationsEndpoint.create(self.application).then(function(app){createAppWizard.app=app,Notifications.success("Application "+self.application.name+" successfully created"),$rootScope.$broadcast("upsUpdateStats"),$router.root.navigate("/wizard/add-variant")}).catch(function(){Notifications.error("Failed to create application "+self.application.name)})}}).factory("createAppWizard",function(){return{app:null,variant:null}}),angular.module("upsConsole").controller("Wizard02AddVariantController",function(variantModal,$router,createAppWizard,Notifications,appModal){this.canActivate=function(){return createAppWizard.app?!0:($router.root.navigate("/wizard/create-app"),!1)};var self=this;this.app=createAppWizard.app,this.addVariant=function(){return variantModal.add(this.app).then(function(variant){createAppWizard.variant=variant,Notifications.success("Variant "+variant.name+" successfully created"),$router.root.navigate("/wizard/register-device")}).catch(function(){Notifications.error("Failed to create variant "+variant.name)})},this.editAppName=function(){var appClone=angular.extend({},self.app);appModal.editName(appClone).then(function(updatedApp){angular.extend(self.app,updatedApp)})}}),angular.module("upsConsole").controller("Wizard03RegisterDeviceController",function(variantModal,$router,createAppWizard,appModal,$timeout,$interval,applicationsEndpoint){function detectInstallations(){return applicationsEndpoint.getWithMetrics({appId:createAppWizard.app.pushApplicationID}).then(function(data){return data.$deviceCount>0}).then(function(installationDetected){installationDetected&&$router.root.navigate("/wizard/send-push-notification")})}this.canActivate=function(){return createAppWizard.app?createAppWizard.variant?!0:($router.root.navigate("/wizard/add-variant"),!1):($router.root.navigate("/wizard/create-app"),!1)};var self=this;this.app=createAppWizard.app,this.variant=createAppWizard.variant,this.addVariant=function(){return variantModal.add().then(function(variant){console.log("success"),console.log(variant),createAppWizard.variant=variant,$router.root.navigate("/wizard/register-device")}).catch(function(){console.log("error")})},this.editAppName=function(){var appClone=angular.extend({},self.app);appModal.editName(appClone).then(function(updatedApp){angular.extend(self.app,updatedApp)})},this.editVariant=function(){var variantClone=angular.extend({},self.variant);return variantModal.edit(self.app,variantClone).then(function(updatedVariant){angular.extend(self.variant,updatedVariant)})};var intervalForDetectInstallations;this.activate=function(){$timeout(function(){intervalForDetectInstallations=$interval(function(){detectInstallations().then(function(installationDetected){installationDetected&&$interval.cancel(intervalForDetectInstallations)})},1500)},1500)},this.canDeactivate=function(){return intervalForDetectInstallations&&$interval.cancel(intervalForDetectInstallations),!0}}),angular.module("upsConsole").controller("Wizard04SendPushNotificationController",function($router,$interval,$timeout,createAppWizard,Notifications,$rootScope,messageSenderEndpoint,appModal,applicationsEndpoint){function updateDeviceCount(){applicationsEndpoint.getWithMetrics({appId:createAppWizard.app.pushApplicationID}).then(function(data){self.deviceCount=data.$deviceCount})}var intervalForUpdateDeviceCount,self=this;this.canActivate=function(){return createAppWizard.app?createAppWizard.variant?!0:($router.root.navigate("/wizard/add-variant"),!1):($router.root.navigate("/wizard/create-app"),!1)},this.app=createAppWizard.app,this.variant=createAppWizard.variant,this.deviceCount=0,this.pushData={message:{sound:"default",alert:"Hello! This is my first notification to "+(self.variant?self.variant.name:null),"simple-push":"version="+(new Date).getTime()},criteria:{}},this.sendNotification=function(){messageSenderEndpoint(self.app.pushApplicationID,self.app.masterSecret).send({},self.pushData).then(function(){$rootScope.$broadcast("upsNotificationSent",self.pushData,self.app),Notifications.success("Notification was successfully sent"),$router.root.navigate("/wizard/setup-sender")}).catch(function(){Notifications.error("Failed to sent notification")})},this.editAppName=function(){var appClone=angular.extend({},self.app);appModal.editName(appClone).then(function(updatedApp){angular.extend(self.app,updatedApp)})},this.activate=function(){updateDeviceCount(),$timeout(function(){intervalForUpdateDeviceCount=$interval(function(){updateDeviceCount(),self.deviceCount>0&&$interval.cancel(intervalForUpdateDeviceCount)},1500)},1500)},this.canDeactivate=function(){return intervalForUpdateDeviceCount&&$interval.cancel(intervalForUpdateDeviceCount),!0}}),angular.module("upsConsole").controller("Wizard05SetupSenderController",function(variantModal,$router,createAppWizard,ContextProvider,appModal){var self=this;this.canActivate=function(){return createAppWizard.app?createAppWizard.variant?!0:($router.root.navigate("/wizard/add-variant"),!1):($router.root.navigate("/wizard/create-app"),!1)},this.app=createAppWizard.app,this.variant=createAppWizard.variant,this.contextPath=ContextProvider.contextPath(),this.editAppName=function(){var appClone=angular.extend({},self.app);appModal.editName(appClone).then(function(updatedApp){angular.extend(self.app,updatedApp)})}}),angular.module("upsConsole").controller("LinksCheckController",function(docsLinks){this.links=docsLinks}),angular.module("upsConsole").factory("appModal",function($modal,applicationsEndpoint){var service={editName:function(app){return $modal.open({templateUrl:"dialogs/edit-app-name.html",controller:function($scope,$modalInstance){$scope.app=app,$scope.confirm=function(){var data={name:app.name,description:app.description};applicationsEndpoint.update({appId:app.pushApplicationID},data).then(function(updatedApp){$modalInstance.close(updatedApp)})},$scope.dismiss=function(){$modalInstance.dismiss("cancel")}}}).result}};return service}),angular.module("upsConsole").factory("variantModal",function($modal,$q,variantsEndpoint){function updateVariant(app,variant){var endpointParams={appId:app.pushApplicationID,variantType:extractVariantType(variant),variantId:variant.variantID},variantData=extractValidVariantData(variant);return"ios"!==variant.type?variantsEndpoint.update(endpointParams,variantData):variant.certificates.length>0?variantsEndpoint.updateWithFormData(endpointParams,variantData):variantsEndpoint.patch(endpointParams,{name:variant.name,description:variant.description,production:variant.production})}function extractValidVariantData(variant){var properties=["name"],result={};switch(variant.type){case"android":properties=properties.concat(["projectNumber","googleKey"]);break;case"simplePush":properties=properties.concat([]);break;case"ios":variant.certificates&&variant.certificates.length&&(variant.certificate=variant.certificates[0]),properties=properties.concat(["production","passphrase","certificate"]);var formData=new FormData;return properties.forEach(function(property){formData.append(property,void 0===variant[property]?"":variant[property])}),formData;case"windows":properties=properties.concat("wns"===variant.protocolType?["sid","clientSecret","protocolType"]:["protocolType"]);break;case"windows_wns":result.protocolType="wns",properties=properties.concat(["sid","clientSecret"]);break;case"windows_mpns":result.protocolType="mpns",properties=properties.concat([]);break;case"adm":properties=properties.concat(["clientId","clientSecret"]);break;default:throw"Unknown variant type "+variant.type}return properties.forEach(function(property){result[property]=variant[property]}),result}function extractVariantType(variant){switch(variant.type){case"windows":return"windows_"+variant.protocolType;default:return variant.type}}var service={editName:function(app,variant){return $modal.open({templateUrl:"dialogs/edit-variant-name.html",controller:function($scope,$modalInstance){$scope.variant=variant,$scope.confirm=function(){updateVariant(app,$scope.variant).then(function(updatedVariant){$modalInstance.close(updatedVariant)})},$scope.dismiss=function(){$modalInstance.dismiss("cancel")}}}).result},add:function(app){return $modal.open({templateUrl:"dialogs/create-variant.html",controller:function($scope,$modalInstance){$scope.isNew=!0,$scope.variant={},$scope.variant.certificates=[],$scope.confirm=function(){var variantData=extractValidVariantData($scope.variant),createFunction=variantData instanceof FormData?variantsEndpoint.createWithFormData:variantsEndpoint.create;createFunction({appId:app.pushApplicationID,variantType:extractVariantType($scope.variant)},variantData).then(function(variant){$modalInstance.close(variant)}).catch(function(err){$modalInstance.dismiss(err)})},$scope.dismiss=function(){$modalInstance.dismiss("cancel")},$scope.validateFileInputs=function(){switch($scope.variant.type){case"ios":return $scope.variant.certificates.length>0}return!0}}}).result},edit:function(app,variant){return $modal.open({templateUrl:"dialogs/create-variant.html",controller:function($scope,$modalInstance){$scope.isNew=!1,$scope.variant=variant,$scope.variant.certificates=[],$scope.confirm=function(){updateVariant(app,$scope.variant).then(function(updatedVariant){$modalInstance.close(updatedVariant)})},$scope.dismiss=function(){$modalInstance.dismiss("cancel")},$scope.validateFileInputs=function(){if("ios"===$scope.variant.type){if(!$scope.variant.id)return $scope.variant.certificates.length>0&&!!variant.passphrase;if($scope.variant.certificates.length>0)return!!variant.passphrase}return!0}}}).result}};return service});var upsServices=angular.module("upsConsole");upsServices.factory("ContextProvider",function($location){return{contextPath:function(){var href=$location.absUrl();return href=href.split("#",1).join(""),href=href.split("?",1).join("")}}});var upsServices=angular.module("upsConsole");upsServices.config(function($httpProvider){$httpProvider.interceptors.push(function($q,$interpolate,Notifications){return{responseError:function(rejection){var messageExpr,message;return 400===rejection.status&&"object"==typeof rejection.data?Object.keys(rejection.data).forEach(function(key){message=rejection.data[key],Notifications.error(message)}):(messageExpr=$interpolate("Server returned {{status}}: {{statusText}}"),message=messageExpr(rejection),Notifications.error(messageExpr(rejection))),$q.reject(rejection)}}})}),angular.module("upsConsole").directive("upsFiles",function(){return{scope:{files:"=upsFiles",onChange:"&onChange"},restrict:"A",replace:!1,link:function($scope,$element){$element.bind("change",function(e){$scope.$apply(function(){for(;$scope.files.length>0;)$scope.files.pop();for(var i in e.target.files)"object"==typeof e.target.files[i]&&$scope.files.push(e.target.files[i]);$scope.onChange()})})}}}).directive("upsDoc",function(docsLinks,$log){return{scope:{docId:"@",param:"="},restrict:"A",replace:!1,link:function($scope,$element,attributes){$element.attr("target","_blank"),attributes.$observe("upsDoc",function(upsDocValue){function updateHref(){var href=docsLinks[upsDocValue];if(href)$element.attr("href",href);else if(Object.keys(docsLinks).length>0)return $log.warn("ups-doc: cannot resolve a link for id: "+upsDocValue),!0;return!!href}if(!updateHref())var unwatch=$scope.$watch(function(){return docsLinks[upsDocValue]},function(){updateHref()&&unwatch()})})}}}).directive("upsPluralize",function(){return{scope:{noun:"@",count:"=",zero:"@"},restrict:"E",template:'<span class="ups-pluralize" ng-if="count > 0"><span class="count">{{ count }}</span> {{ noun }}{{ count > 1 ? "s" : "" }}</span><span class="ups-pluralize zero" ng-if="count == 0"><span class="count">{{ zero == null ? "0" : zero }}</span> {{ noun }}s</span>'}}).directive("upsClientSnippets",function(){return{scope:{variant:"="},controller:function($scope,ContextProvider,$http,$sce,$interpolate,$timeout){$scope.clipText=$sce.trustAsHtml("Copy to clipboard"),$scope.contextPath=ContextProvider.contextPath(),$scope.typeEnum={android:{name:"Android",snippets:["android","cordova"]},ios:{name:"iOS",snippets:["ios_objc","ios_swift","cordova"]},windows_mpns:{name:"Windows",snippets:["mpns","cordova"]},windows_wns:{name:"Windows",snippets:["wns"]},simplePush:{name:"SimplePush",snippets:["cordova"]},adm:{name:"ADM",snippets:["cordova"]}},$scope.state={activeSnippet:$scope.typeEnum[$scope.variant.type].snippets[0]},$scope.snippets={android:{url:"snippets/register-device/android.java"},cordova:{url:"snippets/register-device/cordova.js"},ios_objc:{url:"snippets/register-device/ios.objc"},ios_swift:{url:"snippets/register-device/ios.swift"},mpns:{url:"snippets/register-device/mpns.cs"},wns:{url:"snippets/register-device/wns.cs"}},angular.forEach($scope.snippets,function(value,key){$http.get(value.url).then(function(response){$scope.snippets[key].source=$interpolate(response.data)($scope)})}),$scope.copySnippet=function(){return $scope.snippets[$scope.state.activeSnippet].source},$scope.copied=function(){$scope.clipText="Copied!",$timeout(function(){$scope.clipText="Copy to clipboard"},1e3)},$scope.cordovaVariantType=function(){switch($scope.variant.type){case"windows_mpns":return"windows";default:return $scope.variant.type}}(),$scope.senderID="android"===$scope.variant.type?$scope.variant.projectNumber:null},restrict:"E",templateUrl:"directives/ups-client-snippets.html"}}).directive("upsSenderSnippets",function(){return{scope:{app:"=",activeSnippet:"@"},controller:function($scope,ContextProvider,$http,$sce,$interpolate,$timeout){$scope.activeSnippet=$scope.activeSnippet||"java",$scope.clipText=$sce.trustAsHtml("Copy to clipboard"),$scope.contextPath=ContextProvider.contextPath(),$scope.snippets={java:{url:"snippets/senders/sender.java"},nodejs:{url:"snippets/senders/sender-nodejs.js"},curl:{url:"snippets/senders/sender-curl.sh"}},angular.forEach($scope.snippets,function(value,key){$http.get(value.url).then(function(response){$scope.snippets[key].source=$interpolate(response.data)($scope)})}),$scope.copySnippet=function(){return $scope.snippets[$scope.activeSnippet].source},$scope.copied=function(){$scope.clipText="Copied!",$timeout(function(){$scope.clipText="Copy to clipboard"},1e3)}},restrict:"E",templateUrl:"directives/ups-sender-snippets.html"}}).directive("searchPf",function(){return{scope:{},restrict:"C",replace:!1,link:function($scope,$element){$element.find(".has-clear .clear").each(function(){$(this).prev(".form-control").val()||$(this).hide()}),$element.find(".has-clear .form-control").keyup(function(){var t=$(this);t.next("button").toggle(Boolean(t.val()))}),$element.find(".has-clear .clear").click(function(){$(this).prev(".form-control").val("").focus(),$(this).hide()})}}}).directive("upsWizard",function(){return{scope:{},restrict:"A",replace:!1,link:function($scope,$element){var highestCol=0;$element.find(".well").each(function(){highestCol=Math.max(highestCol,$(this).height())}),$element.find(".well").height(highestCol)}}}).directive("sidebarPf",function(){return{restrict:"C",link:function(){sidebar()}}}).directive("prettyprint",function(){return{restrict:"C",link:function($scope,$element){var unwatch=$scope.$watch(function(){return $element.text()},function(text){text&&(window.requestAnimationFrame(function(){$scope.var=$element.html(),$element.html(prettyPrintOne($element.html(),"",!1))}),unwatch())})}}});var upsServices=angular.module("upsConsole");
upsServices.factory("applicationsEndpoint",function($resource,$q){return $resource("rest/applications/:appId/:verb",{appId:"@appId"},{get:{method:"GET",params:{includeDeviceCount:!0,includeActivity:!0}},list:{method:"GET",isArray:!0,params:{includeDeviceCount:!0,includeActivity:!0}},create:{method:"POST"},update:{method:"PUT"},"delete":{method:"DELETE"},count:{method:"GET",params:{verb:"count"}},reset:{method:"PUT",params:{verb:"reset"}},fetch:function(pageNo){var deferred=$q.defer();return this.list({page:pageNo-1,per_page:8},function(apps,responseHeaders){var result={apps:apps,totalItems:responseHeaders("total")};apps.forEach(function(app){app.$messageCount=parseInt(responseHeaders("activity_app_"+app.pushApplicationID),10),app.$deviceCount=parseInt(responseHeaders("deviceCount_app_"+app.pushApplicationID),10)}),deferred.resolve(result)}),deferred.promise},getWithMetrics:function(params){var deferred=$q.defer();return this.get(params,function(app,responseHeaders){app.$messageCount=parseInt(responseHeaders("activity_app_"+app.pushApplicationID),10),app.$deviceCount=parseInt(responseHeaders("deviceCount_app_"+app.pushApplicationID),10),app.variants.forEach(function(variant){variant.$messageCount=parseInt(responseHeaders("activity_variant_"+variant.variantID),10),variant.$deviceCount=parseInt(responseHeaders("deviceCount_variant_"+variant.variantID),10)}),deferred.resolve(app)}),deferred.promise}})});var upsServices=angular.module("upsConsole");upsServices.factory("variantsEndpoint",function($resource){return $resource("rest/applications/:appId/:variantType/:variantId/:verb",{appId:"@appId",variantType:"@variantType",variantId:"@variantId"},{get:{method:"GET"},query:{method:"GET",isArray:!0},create:{method:"POST"},update:{method:"PUT"},"delete":{method:"DELETE"},patch:{method:"PATCH"},createWithFormData:{method:"POST",headers:{"Content-Type":void 0},withCredentials:!0,transformRequest:angular.identity},updateWithFormData:{method:"PUT",headers:{"Content-Type":void 0},withCredentials:!0,transformRequest:angular.identity},reset:{method:"PUT",params:{verb:"reset"}}})});var upsServices=angular.module("upsConsole");upsServices.factory("messageSenderEndpoint",function($resource){return function(applicationID,masterSecret){return $resource("rest/sender",{},{send:{method:"POST",headers:{"aerogear-sender":"AeroGear UnifiedPush Console",Authorization:"Basic "+btoa(applicationID+":"+masterSecret)}}})}});var upsServices=angular.module("upsConsole");upsServices.factory("metricsEndpoint",function($resource,$q){return $resource("rest/metrics/messages/:verb/:id",{id:"@id"},{application:{method:"GET",isArray:!0,params:{verb:"application"}},fetchApplicationMetrics:function(applicationId,searchString,pageNo,perPage){perPage=perPage||10,searchString=searchString||null;var deferred=$q.defer();return this.application({id:applicationId,page:pageNo-1,per_page:perPage,sort:"desc",search:searchString},function(data,responseHeaders){angular.forEach(data,function(metric){angular.forEach(metric.variantInformations,function(variant){variant.deliveryStatus||(metric.deliveryFailed=!0)})}),deferred.resolve({totalItems:parseInt(responseHeaders("total"),10),receivers:parseInt(responseHeaders("receivers"),10),appOpenedCounter:parseInt(responseHeaders("appOpenedCounter"),10),pushMetrics:data})}),deferred.promise}})});var upsServices=angular.module("upsConsole");upsServices.factory("dashboardEndpoint",function($resource){return $resource("rest/metrics/dashboard/:verb",{},{totals:{method:"GET"},warnings:{method:"GET",isArray:!0,params:{verb:"warnings"}},latestActiveApps:{method:"GET",isArray:!0,params:{verb:"active",count:4}}})});