/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;

@Stateless
@Path(value="/applications/{variantID}/installations/")
public class InstallationManagementEndpoint {
    private static final int MAX_PAGE_SIZE = 50;
    private static final int DEFAULT_PAGE_SIZE = 25;
    @Inject
    private GenericVariantService genericVariantService;
    @Inject
    private ClientInstallationService clientInstallationService;

    @GET
    @Produces(value={"application/json"})
    public Response findInstallations(@PathParam(value="variantID") String variantId, @QueryParam(value="page") Integer page, @QueryParam(value="per_page") Integer pageSize, @Context UriInfo uri, @Context HttpServletRequest request) {
        String developer;
        pageSize = pageSize != null ? Integer.valueOf(Math.min(50, pageSize)) : Integer.valueOf(25);
        if (page == null) {
            page = 0;
        }
        if (!this.genericVariantService.existsVariantIDForDeveloper(variantId, developer = HttpRequestUtil.extractUsername(request))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
        }
        PageResult pageResult = this.clientInstallationService.findInstallationsByVariant(variantId, developer, page, pageSize);
        long totalPages = pageResult.getCount() / (long)pageSize.intValue();
        LinkHeader header = this.getLinkHeader(page, totalPages, uri);
        return Response.ok((Object)pageResult.getResultList()).header("Link", (Object)header.toString()).header("total", (Object)pageResult.getCount()).build();
    }

    LinkHeader getLinkHeader(Integer page, long totalPages, UriInfo uri) {
        LinkHeader header = new LinkHeader();
        if (page != 0) {
            header.addLink(this.buildLink("prev", page - 1, uri));
            header.addLink(this.buildLink("first", 0L, uri));
        }
        if ((long)page.intValue() < totalPages) {
            header.addLink(this.buildLink("next", page + 1, uri));
            header.addLink(this.buildLink("last", totalPages, uri));
        }
        return header;
    }

    private Link buildLink(String rel, long pageNo, UriInfo uri) {
        Link link = new Link();
        link.setHref(uri.getAbsolutePathBuilder().queryParam("page", new Object[]{pageNo}).build(new Object[0]).toASCIIString());
        link.setRelationship(rel);
        return link;
    }

    @GET
    @Path(value="/{installationID}")
    @Produces(value={"application/json"})
    public Response findInstallation(@PathParam(value="variantID") String variantId, @PathParam(value="installationID") String installationId) {
        Installation installation = this.clientInstallationService.findById(installationId);
        if (installation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Installation").build();
        }
        return Response.ok((Object)installation).build();
    }

    @PUT
    @Path(value="/{installationID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateInstallation(Installation entity, @PathParam(value="variantID") String variantId, @PathParam(value="installationID") String installationId) {
        Installation installation = this.clientInstallationService.findById(installationId);
        if (installation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Installation").build();
        }
        this.clientInstallationService.updateInstallation(installation, entity);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{installationID}")
    @Produces(value={"application/json"})
    public Response removeInstallation(@PathParam(value="variantID") String variantId, @PathParam(value="installationID") String installationId) {
        Installation installation = this.clientInstallationService.findById(installationId);
        if (installation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Installation").build();
        }
        this.clientInstallationService.removeInstallation(installation);
        return Response.noContent().build();
    }
}

