/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.SimplePushVariant;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;

@Stateless
@Path(value="/applications/{pushAppID}/simplePush")
public class SimplePushVariantEndpoint
extends AbstractVariantEndpoint {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerSimplePushVariant(SimplePushVariant simplePushVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo, @Context HttpServletRequest request) {
        PushApplication pushApp = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, HttpRequestUtil.extractUsername(request));
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(simplePushVariant);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        simplePushVariant.setDeveloper(HttpRequestUtil.extractUsername(request));
        this.variantService.addVariant((Variant)simplePushVariant);
        this.pushAppService.addVariant(pushApp, (Variant)simplePushVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(simplePushVariant.getVariantID())).build(new Object[0])).entity((Object)simplePushVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllSimplePushVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID, @Context HttpServletRequest request) {
        PushApplication application = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, HttpRequestUtil.extractUsername(request));
        return Response.ok(this.getVariantsByType(application, SimplePushVariant.class)).build();
    }

    @PUT
    @Path(value="/{simplePushID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateSimplePushVariation(@Context HttpServletRequest request, @PathParam(value="pushAppID") String id, @PathParam(value="simplePushID") String simplePushID, SimplePushVariant updatedSimplePushApplication) {
        SimplePushVariant spVariant = (SimplePushVariant)this.variantService.findByVariantIDForDeveloper(simplePushID, HttpRequestUtil.extractUsername(request));
        if (spVariant != null) {
            try {
                this.validateModelClass(updatedSimplePushApplication);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            spVariant.setName(updatedSimplePushApplication.getName());
            spVariant.setDescription(updatedSimplePushApplication.getDescription());
            this.variantService.updateVariant((Variant)spVariant);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

