/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.core.Response;

public abstract class AbstractBaseEndpoint {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    @Inject
    private Validator validator;

    protected void validateModelClass(Object model) {
        Set violations = this.validator.validate(model, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(violations));
        }
    }

    protected Response.ResponseBuilder createBadRequestResponse(Set<ConstraintViolation<?>> violations) {
        HashMap<String, String> responseObj = new HashMap<String, String>();
        for (ConstraintViolation<?> violation : violations) {
            responseObj.put(violation.getPropertyPath().toString(), violation.getMessage());
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseObj);
    }
}

