/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.sender;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.message.NotificationRouter;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.rest.util.HttpBasicHelper;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;

@Path(value="/sender")
public class PushNotificationSenderEndpoint {
    private final AeroGearLogger logger = AeroGearLogger.getInstance(PushNotificationSenderEndpoint.class);
    @Inject
    private PushApplicationService pushApplicationService;
    @Inject
    private NotificationRouter notificationRouter;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response send(UnifiedPushMessage message, @Context HttpServletRequest request) {
        PushApplication pushApplication = this.loadPushApplicationWhenAuthorized(request);
        if (pushApplication == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"AeroGear UnifiedPush Server\"").entity((Object)"Unauthorized Request").build();
        }
        message.setIpAddress(HttpRequestUtil.extractIPAddress(request));
        message.setClientIdentifier(HttpRequestUtil.extractAeroGearSenderInformation(request));
        this.notificationRouter.submit(pushApplication, message);
        this.logger.fine("Message sent by: '" + message.getClientIdentifier() + "'");
        this.logger.info("Message submitted to PushNetworks for further processing");
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)"Job submitted").build();
    }

    private PushApplication loadPushApplicationWhenAuthorized(HttpServletRequest request) {
        String[] credentials = HttpBasicHelper.extractUsernameAndPasswordFromBasicHeader(request);
        String pushApplicationID = credentials[0];
        String secret = credentials[1];
        PushApplication pushApplication = this.pushApplicationService.findByPushApplicationID(pushApplicationID);
        if (pushApplication != null && pushApplication.getMasterSecret().equals(secret)) {
            return pushApplication;
        }
        return null;
    }
}

