/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import com.qmino.miredot.annotations.ReturnType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;

public abstract class AbstractVariantEndpoint
extends AbstractBaseEndpoint {
    @Inject
    protected PushApplicationService pushAppService;
    @Inject
    protected GenericVariantService variantService;

    @PUT
    @Path(value="/{variantId}/reset")
    @Consumes(value={"application/json"})
    @ReturnType(value="org.jboss.aerogear.unifiedpush.api.Variant")
    public Response resetSecret(@PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantID(variantId);
        if (variant != null) {
            this.logger.finest("Resetting secret for: " + variant.getClass().getSimpleName());
            String newSecret = UUID.randomUUID().toString();
            variant.setSecret(newSecret);
            this.variantService.updateVariant(variant);
            return Response.ok((Object)variant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }

    @GET
    @Path(value="/{variantId}")
    @Produces(value={"application/json"})
    @ReturnType(value="org.jboss.aerogear.unifiedpush.api.Variant")
    public Response findVariantById(@PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantID(variantId);
        if (variant != null) {
            return Response.ok((Object)variant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }

    @DELETE
    @Path(value="/{variantId}")
    @ReturnType(value="java.lang.Void")
    public Response deleteVariant(@PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantID(variantId);
        if (variant != null) {
            this.logger.finest("Deleting: " + variant.getClass().getSimpleName());
            this.variantService.removeVariant(variant);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }

    protected <T extends Variant> Set<T> getVariantsByType(PushApplication application, Class<T> type) {
        HashSet<Variant> variants = new HashSet<Variant>();
        for (Variant variant : application.getVariants()) {
            if (!variant.getClass().equals(type)) continue;
            variants.add(variant);
        }
        return variants;
    }
}

