/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.unifiedpush.rest.util.transform.DynamicTransformer;

public class UserParams
implements DynamicTransformer {
    private static final List<String> KNOWN_KEYS = Arrays.asList("alert", "apns", "sound", "badge", "simple-push", "user-data");
    public static final String MOVE_OP = "['{'\"op\": \"move\",\"from\": \"/message/{0}\",\"path\": \"/message/user-data/{0}\"'}']";

    @Override
    public JsonNode transform(JsonNode patched) throws IOException {
        Iterator nodeIterator = patched.get("message").fields();
        while (nodeIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)nodeIterator.next();
            if (KNOWN_KEYS.contains(entry.getKey())) continue;
            String json = MessageFormat.format(MOVE_OP, entry.getKey());
            try {
                patched = JsonPatch.fromJson((JsonNode)JacksonUtils.getReader().readTree(json)).apply(patched);
            }
            catch (JsonPatchException e) {
                throw new RuntimeException("move operation could not be applied", e);
            }
        }
        return patched;
    }
}

