/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.installations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qmino.miredot.annotations.BodyType;
import com.qmino.miredot.annotations.ReturnType;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.api.validation.DeviceTokenValidator;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.rest.registry.installations.ImporterForm;
import org.jboss.aerogear.unifiedpush.rest.util.HttpBasicHelper;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;
import org.jboss.aerogear.unifiedpush.utils.AeroGearLogger;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

@Path(value="/registry/device")
public class InstallationRegistrationEndpoint
extends AbstractBaseEndpoint {
    public static final ObjectMapper mapper = new ObjectMapper();
    private final AeroGearLogger logger = AeroGearLogger.getInstance(InstallationRegistrationEndpoint.class);
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    private GenericVariantService genericVariantService;
    @Inject
    private PushMessageMetricsService metricsService;

    @OPTIONS
    @Path(value="{token: .*}")
    @ReturnType(value="java.lang.Void")
    public Response crossOriginForInstallations(@Context HttpHeaders headers, @PathParam(value="token") String token) {
        return this.appendPreflightResponseHeaders(headers, Response.ok()).build();
    }

    @OPTIONS
    @ReturnType(value="java.lang.Void")
    public Response crossOriginForInstallations(@Context HttpHeaders headers) {
        return this.appendPreflightResponseHeaders(headers, Response.ok()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReturnType(value="org.jboss.aerogear.unifiedpush.api.Installation")
    public Response registerInstallation(Installation entity, @Context HttpServletRequest request) {
        Variant variant = this.loadVariantWhenAuthorized(request);
        if (variant == null) {
            return this.create401Response(request);
        }
        String deviceToken = entity.getDeviceToken();
        if (deviceToken == null || !DeviceTokenValidator.isValidDeviceTokenForVariant((String)deviceToken, (VariantType)variant.getType())) {
            this.logger.finest(String.format("Invalid device token was delivered: %s for variant type: %s", deviceToken, variant.getType()));
            return this.appendAllowOriginHeader(Response.status((Response.Status)Response.Status.BAD_REQUEST), request);
        }
        this.logger.finest("Mobile Application on device was launched");
        this.clientInstallationService.addInstallation(variant, entity);
        return this.appendAllowOriginHeader(Response.ok((Object)entity), request);
    }

    @PUT
    @Path(value="/pushMessage/{id: .*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReturnType(value="org.jboss.aerogear.unifiedpush.rest.EmptyJSON")
    public Response increasePushMessageReadCounter(@PathParam(value="id") String pushMessageId, @Context HttpServletRequest request) {
        Variant variant = this.loadVariantWhenAuthorized(request);
        if (variant == null) {
            return this.create401Response(request);
        }
        if (pushMessageId != null) {
            this.metricsService.updateAnalytics(pushMessageId, variant.getVariantID());
        }
        return Response.ok((Object)"{}").build();
    }

    @DELETE
    @Path(value="{token: .*}")
    @ReturnType(value="java.lang.Void")
    public Response unregisterInstallations(@PathParam(value="token") String token, @Context HttpServletRequest request) {
        Variant variant = this.loadVariantWhenAuthorized(request);
        if (variant == null) {
            return this.create401Response(request);
        }
        Installation installation = this.clientInstallationService.findInstallationForVariantByDeviceToken(variant.getVariantID(), token);
        if (installation == null) {
            return this.appendAllowOriginHeader(Response.status((Response.Status)Response.Status.NOT_FOUND), request);
        }
        this.logger.info("Deleting metadata Installation");
        this.clientInstallationService.removeInstallation(installation);
        return this.appendAllowOriginHeader(Response.noContent(), request);
    }

    @POST
    @Path(value="/importer")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @BodyType(value="org.jboss.aerogear.unifiedpush.rest.registry.installations.ImporterForm")
    @ReturnType(value="org.jboss.aerogear.unifiedpush.rest.EmptyJSON")
    public Response importDevice(@MultipartForm ImporterForm form, @Context HttpServletRequest request) {
        List devices;
        Variant variant = this.loadVariantWhenAuthorized(request);
        if (variant == null) {
            return this.create401Response(request);
        }
        try {
            devices = (List)mapper.readValue(form.getJsonFile(), (TypeReference)new TypeReference<List<Installation>>(){});
        }
        catch (IOException e) {
            this.logger.severe("Error when parsing importer json file", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.logger.info("Devices to import: " + devices.size());
        this.clientInstallationService.addInstallations(variant, devices);
        return Response.ok((Object)"{}").build();
    }

    private Response.ResponseBuilder appendPreflightResponseHeaders(HttpHeaders headers, Response.ResponseBuilder response) {
        response.header("Access-Control-Allow-Origin", headers.getRequestHeader("Origin").get(0)).header("Access-Control-Allow-Methods", (Object)"POST, DELETE").header("Access-Control-Allow-Headers", (Object)"accept, origin, content-type, authorization").header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Max-Age", (Object)"604800");
        return response;
    }

    private Response appendAllowOriginHeader(Response.ResponseBuilder rb, HttpServletRequest request) {
        return rb.header("Access-Control-Allow-Origin", (Object)request.getHeader("Origin")).header("Access-Control-Allow-Credentials", (Object)"true").build();
    }

    private Response create401Response(HttpServletRequest request) {
        return this.appendAllowOriginHeader(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"AeroGear UnifiedPush Server\"").entity((Object)"Unauthorized Request"), request);
    }

    private Variant loadVariantWhenAuthorized(HttpServletRequest request) {
        String[] credentials = HttpBasicHelper.extractUsernameAndPasswordFromBasicHeader(request);
        String variantID = credentials[0];
        String secret = credentials[1];
        Variant variant = this.genericVariantService.findByVariantID(variantID);
        if (variant != null && variant.getSecret().equals(secret)) {
            return variant;
        }
        return null;
    }
}

