/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;

public final class HttpBasicHelper {
    private static final String HTTP_BASIC_SCHEME = "Basic ";

    private HttpBasicHelper() {
    }

    private static boolean isBasic(String authorizationHeader) {
        return authorizationHeader.startsWith(HTTP_BASIC_SCHEME);
    }

    private static String getAuthorizationHeader(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    public static String[] extractUsernameAndPasswordFromBasicHeader(HttpServletRequest request) {
        String username = "";
        String password = "";
        String authorizationHeader = HttpBasicHelper.getAuthorizationHeader(request);
        if (authorizationHeader != null && HttpBasicHelper.isBasic(authorizationHeader)) {
            String base64Token = authorizationHeader.substring(HTTP_BASIC_SCHEME.length());
            String token = new String(Base64.getDecoder().decode(base64Token), StandardCharsets.UTF_8);
            int delimiter = token.indexOf(58);
            if (delimiter != -1) {
                username = token.substring(0, delimiter);
                password = token.substring(delimiter + 1);
            }
        }
        return new String[]{username, password};
    }
}

