/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import javax.validation.constraints.AssertTrue;
import javax.ws.rs.FormParam;
import org.jboss.aerogear.crypto.util.PKCS12;
import org.jboss.resteasy.annotations.providers.multipart.PartType;

public class BootstrapForm {
    private String pushApplicationName;
    private String androidVariantName;
    private String androidGoogleKey;
    private String androidProjectNumber;
    private String iOSVariantName;
    private Boolean iOSProduction;
    private String iOSPassphrase;
    private byte[] iOSCertificate;
    private String windowsType;
    private String windowsVariantName;
    private String windowsSid;
    private String windowsClientSecret;
    private String admVariantName;
    private String admClientId;
    private String admClientSecret;

    public String getPushApplicationName() {
        return this.pushApplicationName;
    }

    @FormParam(value="pushApplicationName")
    public void setPushApplicationName(String pushApplicationName) {
        this.pushApplicationName = pushApplicationName;
    }

    public String getAndroidVariantName() {
        return this.androidVariantName;
    }

    @FormParam(value="androidVariantName")
    public void setAndroidVariantName(String androidVariantName) {
        this.androidVariantName = androidVariantName;
    }

    public String getAndroidGoogleKey() {
        return this.androidGoogleKey;
    }

    @FormParam(value="androidGoogleKey")
    public void setAndroidGoogleKey(String androidGoogleKey) {
        this.androidGoogleKey = androidGoogleKey;
    }

    public String getAndroidProjectNumber() {
        return this.androidProjectNumber;
    }

    @FormParam(value="androidProjectNumber")
    public void setAndroidProjectNumber(String androidProjectNumber) {
        this.androidProjectNumber = androidProjectNumber;
    }

    public String getiOSVariantName() {
        return this.iOSVariantName;
    }

    @FormParam(value="iosVariantName")
    public void setiOSVariantName(String iOSVariantName) {
        this.iOSVariantName = iOSVariantName;
    }

    public Boolean getiOSProduction() {
        return this.iOSProduction;
    }

    @FormParam(value="iosProduction")
    public void setiOSProduction(Boolean iOSProduction) {
        this.iOSProduction = iOSProduction;
    }

    public String getiOSPassphrase() {
        return this.iOSPassphrase;
    }

    @FormParam(value="iosPassphrase")
    public void setiOSPassphrase(String iOSPassphrase) {
        this.iOSPassphrase = iOSPassphrase;
    }

    public byte[] getiOSCertificate() {
        return this.iOSCertificate;
    }

    @FormParam(value="iosCertificate")
    @PartType(value="application/octet-stream")
    public void setiOSCertificate(byte[] iOSCertificate) {
        this.iOSCertificate = iOSCertificate;
    }

    public String getWindowsType() {
        return this.windowsType;
    }

    @FormParam(value="windowsType")
    public void setWindowsType(String windowsType) {
        this.windowsType = windowsType;
    }

    public String getWindowsVariantName() {
        return this.windowsVariantName;
    }

    @FormParam(value="windowsVariantName")
    public void setWindowsVariantName(String windowsVariantName) {
        this.windowsVariantName = windowsVariantName;
    }

    public String getWindowsSid() {
        return this.windowsSid;
    }

    @FormParam(value="windowsSid")
    public void setWindowsSid(String windowsSid) {
        this.windowsSid = windowsSid;
    }

    public String getWindowsClientSecret() {
        return this.windowsClientSecret;
    }

    @FormParam(value="windowsClientSecret")
    public void setWindowsClientSecret(String windowsClientSecret) {
        this.windowsClientSecret = windowsClientSecret;
    }

    public String getAdmVariantName() {
        return this.admVariantName;
    }

    @FormParam(value="admVariantName")
    public void setAdmVariantName(String admVariantName) {
        this.admVariantName = admVariantName;
    }

    public String getAdmClientId() {
        return this.admClientId;
    }

    @FormParam(value="admClientId")
    public void setAdmClientId(String admClientId) {
        this.admClientId = admClientId;
    }

    public String getAdmClientSecret() {
        return this.admClientSecret;
    }

    @FormParam(value="admClientSecret")
    public void setAdmClientSecret(String admClientSecret) {
        this.admClientSecret = admClientSecret;
    }

    @AssertTrue(message="invalid android data")
    public boolean isAndroidValid() {
        return this.androidVariantName == null || this.androidGoogleKey != null && !this.androidGoogleKey.isEmpty() && this.androidProjectNumber != null && !this.androidProjectNumber.isEmpty();
    }

    @AssertTrue(message="invalid Windows data")
    public boolean isWindowsValid() {
        return this.windowsVariantName == null || this.windowsType == null || !this.windowsType.equalsIgnoreCase("wns") || this.windowsSid != null && !this.windowsSid.isEmpty() && this.windowsClientSecret != null && !this.windowsClientSecret.isEmpty();
    }

    @AssertTrue(message="the provided ios certificate passphrase does not match with the uploaded certificate")
    public boolean isAppleVariantValid() {
        if (this.iOSVariantName != null) {
            try {
                PKCS12.validate((byte[])this.iOSCertificate, (String)this.iOSPassphrase);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

