/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.AdmVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;

@Path(value="/applications/{pushAppID}/adm")
public class AdmVariantEndpoint
extends AbstractVariantEndpoint {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerAdmVariant(AdmVariant admVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(admVariant);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.variantService.addVariant((Variant)admVariant);
        this.pushAppService.addVariant(pushApp, (Variant)admVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(admVariant.getVariantID())).build(new Object[0])).entity((Object)admVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllAdmVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariantsByType(application, AdmVariant.class)).build();
    }

    @PUT
    @Path(value="/{admID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAndroidVariation(@PathParam(value="pushAppID") String id, @PathParam(value="admID") String androidID, AdmVariant updatedAdmApplication) {
        AdmVariant admVariant = (AdmVariant)this.variantService.findByVariantID(androidID);
        if (admVariant != null) {
            try {
                this.validateModelClass(updatedAdmApplication);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            admVariant.setClientId(updatedAdmApplication.getClientId());
            admVariant.setClientSecret(updatedAdmApplication.getClientSecret());
            admVariant.setName(updatedAdmApplication.getName());
            admVariant.setDescription(updatedAdmApplication.getDescription());
            this.variantService.updateVariant((Variant)admVariant);
            return Response.ok((Object)admVariant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

