/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.WindowsVariant;
import org.jboss.aerogear.unifiedpush.api.WindowsWNSVariant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;

@Path(value="/applications/{pushAppID}/windows{type}")
public class WindowsVariantEndpoint
extends AbstractVariantEndpoint {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerWindowsVariant(WindowsVariant windowsVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(windowsVariant);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.variantService.addVariant((Variant)windowsVariant);
        this.pushAppService.addVariant(pushApp, (Variant)windowsVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(windowsVariant.getVariantID())).build(new Object[0])).entity((Object)windowsVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllWindowsVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariantsByType(application, WindowsVariant.class)).build();
    }

    @PUT
    @Path(value="/{windowsID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateWindowsVariation(@PathParam(value="windowsID") String windowsID, WindowsVariant updatedWindowsVariant) {
        WindowsVariant windowsVariant = (WindowsVariant)this.variantService.findByVariantID(windowsID);
        if (windowsVariant != null) {
            try {
                this.validateModelClass(updatedWindowsVariant);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            if (windowsVariant instanceof WindowsWNSVariant) {
                WindowsWNSVariant windowsWNSVariant = (WindowsWNSVariant)windowsVariant;
                windowsWNSVariant.setClientSecret(((WindowsWNSVariant)updatedWindowsVariant).getClientSecret());
                windowsWNSVariant.setSid(((WindowsWNSVariant)updatedWindowsVariant).getSid());
            }
            windowsVariant.setName(updatedWindowsVariant.getName());
            windowsVariant.setDescription(updatedWindowsVariant.getDescription());
            this.variantService.updateVariant((Variant)windowsVariant);
            return Response.ok((Object)windowsVariant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

