/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.message.HealthNetworkService;
import org.jboss.aerogear.unifiedpush.service.HealthDBService;
import org.jboss.aerogear.unifiedpush.service.impl.health.HealthDetails;
import org.jboss.aerogear.unifiedpush.service.impl.health.HealthStatus;

@Path(value="/sys/info")
public class HealthCheck {
    @Inject
    private HealthDBService healthDBService;
    @Inject
    private HealthNetworkService healthNetworkService;

    @GET
    @Path(value="/health")
    @Produces(value={"application/json"})
    public HealthStatus health() throws ExecutionException, InterruptedException {
        HealthStatus status = new HealthStatus();
        Future dbStatus = this.healthDBService.dbStatus();
        Future networkStatus = this.healthNetworkService.networkStatus();
        status.add((HealthDetails)dbStatus.get());
        ((List)networkStatus.get()).forEach(arg_0 -> ((HealthStatus)status).add(arg_0));
        return status;
    }

    @GET
    @Path(value="/ping")
    @Produces(value={"text/plain"})
    public Response ping() {
        return Response.ok((Object)"OK").build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public Response manifestDetails(@Context HttpServletRequest request) {
        ServletContext context = request.getSession().getServletContext();
        try (InputStream manifestStream = context.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Response response = Response.ok((Object)new Manifest(manifestStream).getMainAttributes()).build();
            return response;
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find version information").build();
        }
    }
}

