/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class HttpRequestUtil {
    private static final Pattern IP_ADDR_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");

    private HttpRequestUtil() {
    }

    public static String extractIPAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (HttpRequestUtil.isIPAdressValid(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (HttpRequestUtil.isIPAdressValid(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (HttpRequestUtil.isIPAdressValid(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String extractAeroGearSenderInformation(HttpServletRequest request) {
        String client = request.getHeader("aerogear-sender");
        if (HttpRequestUtil.hasValue(client)) {
            return client;
        }
        return request.getHeader("user-agent");
    }

    private static boolean isIPAdressValid(String ip) {
        if (HttpRequestUtil.hasValue(ip)) {
            return IP_ADDR_PATTERN.matcher(ip).matches();
        }
        return false;
    }

    private static boolean hasValue(String value) {
        return value != null && !value.isEmpty();
    }
}

