/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.service.PushSearchService;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseEndpoint {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private Validator validator;
    @Inject
    private SearchManager searchManager;
    @Context
    private HttpServletRequest httpServletRequest;

    protected void validateModelClass(Object model) {
        Set violations = this.validator.validate(model, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(violations));
        }
    }

    protected Response.ResponseBuilder createBadRequestResponse(Set<ConstraintViolation<?>> violations) {
        Map<String, String> responseObj = violations.stream().collect(Collectors.toMap(v -> v.getPropertyPath().toString(), ConstraintViolation::getMessage));
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseObj);
    }

    protected PushSearchService getSearch() {
        return this.searchManager.getSearchService();
    }
}

