/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dto.Count;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;

@Path(value="/applications")
public class PushApplicationEndpoint
extends AbstractBaseEndpoint {
    private static final int MAX_PAGE_SIZE = 25;
    private static final int DEFAULT_PAGE_SIZE = 8;
    @Inject
    private PushApplicationService pushAppService;
    @Inject
    private PushMessageMetricsService metricsService;
    @Inject
    private InstallationDao installationDao;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerPushApplication(PushApplication pushApp) {
        try {
            this.validateModelClass(pushApp);
        }
        catch (ConstraintViolationException cve) {
            return this.createBadRequestResponse(cve.getConstraintViolations()).build();
        }
        try {
            this.pushAppService.addPushApplication(pushApp);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e.getMessage()).build();
        }
        URI uri = UriBuilder.fromResource(PushApplicationEndpoint.class).path(pushApp.getPushApplicationID()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)pushApp).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllPushApplications(@QueryParam(value="page") Integer page, @QueryParam(value="per_page") Integer pageSize, @QueryParam(value="includeDeviceCount") @DefaultValue(value="false") boolean includeDeviceCount, @QueryParam(value="includeActivity") @DefaultValue(value="false") boolean includeActivity) {
        pageSize = pageSize != null ? Integer.valueOf(Math.min(25, pageSize)) : Integer.valueOf(8);
        if (page == null) {
            page = 0;
        }
        PageResult pageResult = this.getSearch().findAllPushApplicationsForDeveloper(page, pageSize);
        Response.ResponseBuilder response = Response.ok((Object)pageResult.getResultList());
        response.header("total", (Object)((Count)pageResult.getAggregate()).getCount());
        for (PushApplication app : pageResult.getResultList()) {
            if (includeActivity) {
                this.putActivityIntoResponseHeaders(app, response);
            }
            if (!includeDeviceCount) continue;
            this.putDeviceCountIntoResponseHeaders(app, response);
        }
        return response.build();
    }

    @GET
    @Path(value="/{pushAppID}")
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="pushAppID") String pushApplicationID, @QueryParam(value="includeDeviceCount") @DefaultValue(value="false") boolean includeDeviceCount, @QueryParam(value="includeActivity") @DefaultValue(value="false") boolean includeActivity) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            Response.ResponseBuilder response = Response.ok((Object)pushApp);
            if (includeActivity) {
                this.putActivityIntoResponseHeaders(pushApp, response);
            }
            if (includeDeviceCount) {
                this.putDeviceCountIntoResponseHeaders(pushApp, response);
            }
            return response.build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    private void putActivityIntoResponseHeaders(PushApplication app, Response.ResponseBuilder response) {
        response.header("activity_app_" + app.getPushApplicationID(), (Object)this.metricsService.countMessagesForPushApplication(app.getPushApplicationID()));
    }

    private void putDeviceCountIntoResponseHeaders(PushApplication app, Response.ResponseBuilder response) {
        long appCount = 0L;
        for (Variant variant : app.getVariants()) {
            long variantCount = this.installationDao.getNumberOfDevicesForVariantID(variant.getVariantID());
            appCount += variantCount;
            response.header("deviceCount_variant_" + variant.getVariantID(), (Object)variantCount);
        }
        response.header("deviceCount_app_" + app.getPushApplicationID(), (Object)appCount);
    }

    @PUT
    @Path(value="/{pushAppID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePushApplication(@PathParam(value="pushAppID") String pushApplicationID, PushApplication updatedPushApp) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            try {
                this.validateModelClass(updatedPushApp);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            pushApp.setDescription(updatedPushApp.getDescription());
            pushApp.setName(updatedPushApp.getName());
            this.pushAppService.updatePushApplication(pushApp);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    @PUT
    @Path(value="/{pushAppID}/reset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetMasterSecret(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            String newMasterSecret = UUID.randomUUID().toString();
            pushApp.setMasterSecret(newMasterSecret);
            this.pushAppService.updatePushApplication(pushApp);
            return Response.ok((Object)pushApp).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    @DELETE
    @Path(value="/{pushAppID}")
    @Produces(value={"application/json"})
    public Response deletePushApplication(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp != null) {
            this.pushAppService.removePushApplication(pushApp);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
    }

    @GET
    @Path(value="/{pushAppID}/count")
    @Produces(value={"application/json"})
    public Response countInstallations(@PathParam(value="pushAppID") String pushApplicationID) {
        Map result = this.pushAppService.countInstallationsByType(pushApplicationID);
        return Response.ok((Object)result).build();
    }
}

