/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;

public abstract class AbstractVariantEndpoint<T extends Variant>
extends AbstractBaseEndpoint {
    private final Class<T> type;
    @Inject
    protected PushApplicationService pushAppService;
    @Inject
    protected GenericVariantService variantService;

    AbstractVariantEndpoint(Class<T> type) {
        this.type = type;
    }

    AbstractVariantEndpoint(Validator validator, SearchManager searchManager, Class<T> type) {
        super(validator, searchManager);
        this.type = type;
    }

    @PUT
    @Path(value="/{variantId}/reset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetSecret(@PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantID(variantId);
        if (variant == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
        }
        if (!this.type.isInstance(variant)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Requested Variant is of another type/platform").build();
        }
        this.logger.trace("Resetting secret for: {}", (Object)variant.getName());
        String newSecret = UUID.randomUUID().toString();
        variant.setSecret(newSecret);
        this.variantService.updateVariant(variant);
        return Response.ok((Object)variant).build();
    }

    @GET
    @Path(value="/{variantId}")
    @Produces(value={"application/json"})
    public Response findVariantById(@PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantID(variantId);
        if (variant == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
        }
        if (!this.type.isInstance(variant)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Requested Variant is of another type/platform").build();
        }
        return Response.ok((Object)variant).build();
    }

    @DELETE
    @Path(value="/{variantId}")
    public Response deleteVariant(@PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantID(variantId);
        if (variant == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
        }
        if (!this.type.isInstance(variant)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Requested Variant is of another type/platform").build();
        }
        this.logger.trace("Deleting: {}", (Object)variant.getClass().getSimpleName());
        this.variantService.removeVariant(variant);
        return Response.noContent().build();
    }

    protected Set<T> getVariants(PushApplication application) {
        return application.getVariants().stream().filter(variant -> this.type.isAssignableFrom(variant.getClass())).map(variant -> variant).collect(Collectors.toSet());
    }
}

