/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.WindowsVariant;
import org.jboss.aerogear.unifiedpush.api.WindowsWNSVariant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;

@Path(value="/applications/{pushAppID}/windows{type}")
public class WindowsVariantEndpoint
extends AbstractVariantEndpoint<WindowsVariant> {
    public WindowsVariantEndpoint() {
        super(WindowsVariant.class);
    }

    WindowsVariantEndpoint(Validator validator, SearchManager searchManager) {
        super(validator, searchManager, WindowsVariant.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerWindowsVariant(WindowsVariant windowsVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(windowsVariant);
        }
        catch (ConstraintViolationException cve) {
            this.logger.trace("Unable to create Windows variant");
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.logger.trace("Register Windows variant with Push Application '{}'", (Object)pushApplicationID);
        this.variantService.addVariant((Variant)windowsVariant);
        this.pushAppService.addVariant(pushApp, (Variant)windowsVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(windowsVariant.getVariantID())).build(new Object[0])).entity((Object)windowsVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllWindowsVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariants(application)).build();
    }

    @PUT
    @Path(value="/{windowsID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateWindowsVariant(@PathParam(value="windowsID") String windowsID, WindowsVariant updatedWindowsVariant) {
        WindowsVariant windowsVariant = (WindowsVariant)this.variantService.findByVariantID(windowsID);
        if (windowsVariant != null) {
            try {
                this.validateModelClass(updatedWindowsVariant);
            }
            catch (ConstraintViolationException cve) {
                this.logger.info("Unable to update Windows Variant '{}'", (Object)windowsVariant.getVariantID());
                this.logger.debug("Details: {}", (Throwable)cve);
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            if (windowsVariant instanceof WindowsWNSVariant) {
                WindowsWNSVariant windowsWNSVariant = (WindowsWNSVariant)windowsVariant;
                windowsWNSVariant.setClientSecret(((WindowsWNSVariant)updatedWindowsVariant).getClientSecret());
                windowsWNSVariant.setSid(((WindowsWNSVariant)updatedWindowsVariant).getSid());
            }
            windowsVariant.setName(updatedWindowsVariant.getName());
            windowsVariant.setDescription(updatedWindowsVariant.getDescription());
            this.logger.trace("Updating Windows Variant '{}'", (Object)windowsVariant.getVariantID());
            this.variantService.updateVariant((Variant)windowsVariant);
            return Response.ok((Object)windowsVariant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

