/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.metrics;

import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.service.dashboard.DashboardData;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;

@Path(value="/metrics/dashboard")
public class DashboardEndpoint {
    @Inject
    private SearchManager service;

    @GET
    @Produces(value={"application/json"})
    public Response totalApplications(@Context HttpServletRequest request) {
        DashboardData dataForUser = this.service.getSearchService().loadDashboardData();
        return Response.ok((Object)dataForUser).build();
    }

    @GET
    @Path(value="/warnings")
    @Produces(value={"application/json"})
    public Response getVariantsWithWarnings(@Context HttpServletRequest request) {
        List variantsWithWarnings = this.service.getSearchService().getVariantsWithWarnings();
        return Response.ok((Object)variantsWithWarnings).build();
    }

    @GET
    @Path(value="/active")
    @Produces(value={"application/json"})
    public Response getLatestActivity(@QueryParam(value="count") @DefaultValue(value="3") int count, @Context HttpServletRequest request) {
        List latestActivity = this.service.getSearchService().getLatestActivity(count);
        return Response.ok((Object)latestActivity).build();
    }
}

