/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.WebPushVariant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;

@Path(value="/applications/{pushAppID}/webpush")
public class WebPushVariantEndpoint
extends AbstractVariantEndpoint<WebPushVariant> {
    public WebPushVariantEndpoint() {
        super(WebPushVariant.class);
    }

    WebPushVariantEndpoint(Validator validator, SearchManager searchManager) {
        super(validator, searchManager, WebPushVariant.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerWebPushVariant(WebPushVariant webPushVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(webPushVariant);
        }
        catch (ConstraintViolationException cve) {
            this.logger.trace("Unable to create WebPush variant");
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.logger.trace("Register WebPush variant with Push Application '{}'", (Object)pushApplicationID);
        this.variantService.addVariant((Variant)webPushVariant);
        this.pushAppService.addVariant(pushApp, (Variant)webPushVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(webPushVariant.getVariantID())).build(new Object[0])).entity((Object)webPushVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllWebPushVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariants(application)).build();
    }

    @PUT
    @Path(value="/{webPushID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateWebPushVariant(@PathParam(value="pushAppID") String id, @PathParam(value="webPushID") String webPushID, WebPushVariant updatedVariant) {
        WebPushVariant webPushVariant = (WebPushVariant)this.variantService.findByVariantID(webPushID);
        if (webPushVariant != null) {
            try {
                this.validateModelClass(updatedVariant);
            }
            catch (ConstraintViolationException cve) {
                this.logger.info("Unable to update WebPush Variant '{}'", (Object)webPushVariant.getVariantID());
                this.logger.debug("Details: {}", (Throwable)cve);
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            webPushVariant.setPublicKey(updatedVariant.getPublicKey());
            webPushVariant.setPrivateKey(updatedVariant.getPrivateKey());
            webPushVariant.setName(updatedVariant.getName());
            webPushVariant.setDescription(updatedVariant.getDescription());
            this.logger.trace("Updating WebPush Variant '{}'", (Object)webPushID);
            this.variantService.updateVariant((Variant)webPushVariant);
            return Response.ok((Object)webPushVariant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

