/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.APNSVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.iOSTokenVariant;
import org.jboss.aerogear.unifiedpush.message.jms.APNSClientProducer;
import org.jboss.aerogear.unifiedpush.rest.annotations.PATCH;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;

@Path(value="/applications/{pushAppID}/ios_token")
public class iOSTokenVariantEndpoint
extends AbstractVariantEndpoint<iOSTokenVariant> {
    @Inject
    protected APNSClientProducer producer;

    public iOSTokenVariantEndpoint() {
        super(iOSTokenVariant.class);
    }

    iOSTokenVariantEndpoint(Validator validator, SearchManager searchManager) {
        super(validator, searchManager, iOSTokenVariant.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registeriOSVariant(iOSTokenVariant iOSVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(iOSVariant);
        }
        catch (ConstraintViolationException cve) {
            this.logger.trace("Unable to create iOS variant entity");
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.logger.trace("Register iOS token variant with Push Application '{}'", (Object)pushApplicationID);
        this.variantService.addVariant((Variant)iOSVariant);
        this.pushAppService.addVariant(pushApp, (Variant)iOSVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(iOSVariant.getVariantID())).build(new Object[0])).entity((Object)iOSVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAlliOSVariantsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariants(application)).build();
    }

    @PATCH
    @Path(value="/{iOSID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateiOSVariant(@PathParam(value="pushAppID") String pushApplicationId, @PathParam(value="iOSID") String iOSID, iOSTokenVariant updatediOSVariant) {
        iOSTokenVariant iOSTokenVariant2 = (iOSTokenVariant)this.variantService.findByVariantID(iOSID);
        if (iOSTokenVariant2 != null) {
            iOSTokenVariant2.setName(updatediOSVariant.getName());
            iOSTokenVariant2.setDescription(updatediOSVariant.getDescription());
            iOSTokenVariant2.setProduction(updatediOSVariant.isProduction());
            iOSTokenVariant2.setKeyId(updatediOSVariant.getKeyId());
            iOSTokenVariant2.setBundleId(updatediOSVariant.getBundleId());
            iOSTokenVariant2.setTeamId(updatediOSVariant.getTeamId());
            iOSTokenVariant2.setPrivateKey(updatediOSVariant.getPrivateKey());
            this.logger.trace("Updating text details on iOS Variant '{}'", (Object)iOSID);
            this.variantService.updateVariant((Variant)iOSTokenVariant2);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }

    @PUT
    @Path(value="/{iOSID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateiOSVariant(iOSTokenVariant updatediOSVariant, @PathParam(value="pushAppID") String pushApplicationId, @PathParam(value="iOSID") String iOSID) {
        iOSTokenVariant iOSTokenVariant2 = (iOSTokenVariant)this.variantService.findByVariantID(iOSID);
        if (iOSTokenVariant2 != null) {
            try {
                this.validateModelClass(updatediOSVariant);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            iOSTokenVariant2.setName(updatediOSVariant.getName());
            iOSTokenVariant2.setDescription(updatediOSVariant.getDescription());
            iOSTokenVariant2.setProduction(updatediOSVariant.isProduction());
            iOSTokenVariant2.setKeyId(updatediOSVariant.getKeyId());
            iOSTokenVariant2.setTeamId(updatediOSVariant.getTeamId());
            iOSTokenVariant2.setBundleId(updatediOSVariant.getBundleId());
            iOSTokenVariant2.setPrivateKey(updatediOSVariant.getPrivateKey());
            this.logger.trace("Updating iOS Variant '{}'", (Object)iOSTokenVariant2.getVariantID());
            this.variantService.updateVariant((Variant)iOSTokenVariant2);
            this.producer.changeAPNClient((APNSVariant)iOSTokenVariant2);
            return Response.ok((Object)iOSTokenVariant2).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

