/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.unifiedpush.api.APNSVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.jboss.aerogear.unifiedpush.message.jms.APNSClientProducer;
import org.jboss.aerogear.unifiedpush.rest.annotations.PATCH;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;
import org.jboss.aerogear.unifiedpush.rest.util.iOSApplicationUploadForm;
import org.jboss.aerogear.unifiedpush.service.impl.SearchManager;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

@Path(value="/applications/{pushAppID}/ios")
public class iOSVariantEndpoint
extends AbstractVariantEndpoint<iOSVariant> {
    @Inject
    protected APNSClientProducer producer;

    public iOSVariantEndpoint() {
        super(iOSVariant.class);
    }

    iOSVariantEndpoint(Validator validator, SearchManager searchManager) {
        super(validator, searchManager, iOSVariant.class);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response registeriOSVariant(@MultipartForm iOSApplicationUploadForm form, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplicationEntity").build();
        }
        try {
            this.validateModelClass(form);
        }
        catch (ConstraintViolationException cve) {
            this.logger.trace("Unable to validate given form upload");
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        iOSVariant iOSVariant2 = new iOSVariant();
        iOSVariant2.setName(form.getName());
        iOSVariant2.setDescription(form.getDescription());
        iOSVariant2.setPassphrase(form.getPassphrase());
        iOSVariant2.setCertificate(form.getCertificate());
        iOSVariant2.setProduction(form.getProduction().booleanValue());
        iOSVariant2.setVariantID(form.getVariantID());
        iOSVariant2.setSecret(form.getSecret());
        try {
            this.validateModelClass(iOSVariant2);
        }
        catch (ConstraintViolationException cve) {
            this.logger.trace("Unable to create iOS variant entity");
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        this.logger.trace("Register iOS variant with Push Application '{}'", (Object)pushApplicationID);
        this.variantService.addVariant((Variant)iOSVariant2);
        this.pushAppService.addVariant(pushApp, (Variant)iOSVariant2);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(iOSVariant2.getVariantID())).build(new Object[0])).entity((Object)iOSVariant2).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAlliOSVariantsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication application = this.getSearch().findByPushApplicationIDForDeveloper(pushApplicationID);
        return Response.ok(this.getVariants(application)).build();
    }

    @PATCH
    @Path(value="/{iOSID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateiOSVariant(@PathParam(value="pushAppID") String pushApplicationId, @PathParam(value="iOSID") String iOSID, iOSVariant updatediOSVariant) {
        iOSVariant iOSVariant2 = (iOSVariant)this.variantService.findByVariantID(iOSID);
        if (iOSVariant2 != null) {
            iOSVariant2.setName(updatediOSVariant.getName());
            iOSVariant2.setDescription(updatediOSVariant.getDescription());
            iOSVariant2.setProduction(updatediOSVariant.isProduction());
            this.logger.trace("Updating text details on iOS Variant '{}'", (Object)iOSID);
            this.variantService.updateVariant((Variant)iOSVariant2);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }

    @PUT
    @Path(value="/{iOSID}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response updateiOSVariant(@MultipartForm iOSApplicationUploadForm updatedForm, @PathParam(value="pushAppID") String pushApplicationId, @PathParam(value="iOSID") String iOSID) {
        iOSVariant iOSVariant2 = (iOSVariant)this.variantService.findByVariantID(iOSID);
        if (iOSVariant2 != null) {
            try {
                this.validateModelClass(updatedForm);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            iOSVariant2.setName(updatedForm.getName());
            iOSVariant2.setDescription(updatedForm.getDescription());
            iOSVariant2.setPassphrase(updatedForm.getPassphrase());
            iOSVariant2.setCertificate(updatedForm.getCertificate());
            iOSVariant2.setProduction(updatedForm.getProduction().booleanValue());
            try {
                this.validateModelClass(iOSVariant2);
            }
            catch (ConstraintViolationException cve) {
                this.logger.info("Unable to update iOS Variant '{}'", (Object)iOSVariant2.getVariantID());
                this.logger.debug("Details: {}", (Throwable)cve);
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            this.logger.trace("Updating iOS Variant '{}'", (Object)iOSVariant2.getVariantID());
            this.variantService.updateVariant((Variant)iOSVariant2);
            this.producer.changeAPNClient((APNSVariant)iOSVariant2);
            return Response.ok((Object)iOSVariant2).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

