/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.util;

import java.util.UUID;
import javax.validation.constraints.AssertTrue;
import javax.ws.rs.FormParam;
import org.jboss.aerogear.crypto.util.PKCS12;
import org.jboss.resteasy.annotations.providers.multipart.PartType;

public class iOSApplicationUploadForm {
    private Boolean production;
    private String passphrase;
    private byte[] certificate;
    private String name;
    private String description;
    private String variantID = UUID.randomUUID().toString();
    private String secret = UUID.randomUUID().toString();

    public Boolean getProduction() {
        return this.production;
    }

    @FormParam(value="production")
    public void setProduction(Boolean production) {
        this.production = production;
    }

    public String getName() {
        return this.name;
    }

    @FormParam(value="variantID")
    public void setVariantID(String variantID) {
        this.variantID = variantID;
    }

    @FormParam(value="secret")
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getVariantID() {
        return this.variantID;
    }

    @FormParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    @FormParam(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    @FormParam(value="passphrase")
    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    @FormParam(value="certificate")
    @PartType(value="application/octet-stream")
    public void setCertificate(byte[] data) {
        this.certificate = data;
    }

    @AssertTrue(message="the provided certificate passphrase does not match with the uploaded certificate")
    public boolean isCertificatePassphraseValid() {
        try {
            PKCS12.validate((byte[])this.certificate, (String)this.passphrase);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

