/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.VariantDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAVariantDao
extends JPABaseDao
implements VariantDao {
    public void create(Variant variant) {
        this.persist(variant);
    }

    public void update(Variant variant) {
        this.merge(variant);
    }

    public void delete(Variant variant) {
        List resultList = this.entityManager.createQuery("from Installation i where i.variant = :variant", Installation.class).setParameter("variant", (Object)variant).getResultList();
        for (Installation installation : resultList) {
            this.entityManager.remove((Object)installation);
        }
        Variant entity = (Variant)this.entityManager.find(Variant.class, (Object)variant.getId());
        this.remove(entity);
    }

    public Variant findByVariantID(String variantID) {
        return this.getSingleResultForQuery(this.createQuery("select t from Variant t where t.variantID = :variantID").setParameter("variantID", (Object)variantID));
    }

    public boolean existsVariantIDForDeveloper(String variantID, String loginName) {
        Long numberOfVariants = (Long)this.createQuery("select count(t) from Variant t where t.variantID = :variantID and t.developer = :developer").setParameter("variantID", (Object)variantID).setParameter("developer", (Object)loginName).getSingleResult();
        return numberOfVariants == 1L;
    }

    public List<String> findVariantIDsForDeveloper(String loginName) {
        return this.createQuery("select t.variantID from Variant t where t.developer = :developer").setParameter("developer", (Object)loginName).getResultList();
    }

    public List<Variant> findAllVariantsByIDs(List<String> variantIDs) {
        if (variantIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createQuery("select t from Variant t where t.variantID IN :variantIDs").setParameter("variantIDs", variantIDs).getResultList();
    }

    public Variant find(String id) {
        return (Variant)this.entityManager.find(Variant.class, (Object)id);
    }

    private Variant getSingleResultForQuery(Query query) {
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (Variant)result.get(0);
        }
        return null;
    }

    public boolean existsVariantIDForAdmin(String variantID) {
        Long numberOfVariants = (Long)this.createQuery("select count(t) from Variant t where t.variantID = :variantID").setParameter("variantID", (Object)variantID).getSingleResult();
        return numberOfVariants == 1L;
    }
}

