/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.VariantType;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushApplicationDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAPushApplicationDao
extends JPABaseDao
implements PushApplicationDao {
    public void create(PushApplication pushApplication) {
        this.persist(pushApplication);
    }

    public void update(PushApplication pushApplication) {
        this.merge(pushApplication);
    }

    public void delete(PushApplication pushApplication) {
        PushApplication entity = (PushApplication)this.entityManager.find(PushApplication.class, (Object)pushApplication.getId());
        List variants = entity.getVariants();
        if (variants != null && !variants.isEmpty()) {
            List resultList = this.entityManager.createQuery("from Installation i where i.variant in :variants", Installation.class).setParameter("variants", (Object)variants).getResultList();
            for (Installation installation : resultList) {
                this.entityManager.remove((Object)installation);
            }
        }
        this.remove(entity);
    }

    public PageResult<PushApplication> findAllForDeveloper(String loginName, Integer page, Integer pageSize) {
        String select = "from PushApplication pa where pa.developer = :developer";
        Long count = (Long)this.entityManager.createQuery("select count(*) " + select, Long.class).setParameter("developer", (Object)loginName).getSingleResult();
        List entities = this.entityManager.createQuery("select pa " + select, PushApplication.class).setFirstResult(page * pageSize).setMaxResults(pageSize.intValue()).setParameter("developer", (Object)loginName).getResultList();
        return new PageResult(entities, count.longValue());
    }

    public List<String> findAllPushApplicationIDsForDeveloper(String loginName) {
        return this.createQuery("select pa.pushApplicationID from PushApplication pa where pa.developer = :developer").setParameter("developer", (Object)loginName).getResultList();
    }

    public PushApplication findByPushApplicationIDForDeveloper(String pushApplicationID, String loginName) {
        return this.getSingleResultForQuery(this.createQuery("select pa from PushApplication pa where pa.pushApplicationID = :pushApplicationID and pa.developer = :developer").setParameter("pushApplicationID", (Object)pushApplicationID).setParameter("developer", (Object)loginName));
    }

    public PushApplication findByPushApplicationID(String pushApplicationID) {
        return this.getSingleResultForQuery(this.createQuery("select pa from PushApplication pa where pa.pushApplicationID = :pushApplicationID").setParameter("pushApplicationID", (Object)pushApplicationID));
    }

    public Map<String, Long> countInstallationsByType(String pushApplicationID) {
        String jpql = "select v.type, v.variantID, count(*) from Installation i join i.variant v where i.variant.variantID in (select v.variantID from PushApplication pa join pa.variants v where pushApplicationID = :pushApplicationID) group by v.type, v.variantID";
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (VariantType type : VariantType.values()) {
            results.put(type.getTypeName(), 0L);
        }
        Query query = this.createQuery("select v.type, v.variantID, count(*) from Installation i join i.variant v where i.variant.variantID in (select v.variantID from PushApplication pa join pa.variants v where pushApplicationID = :pushApplicationID) group by v.type, v.variantID").setParameter("pushApplicationID", (Object)pushApplicationID);
        List resultList = query.getResultList();
        for (Object[] objects : resultList) {
            Long value = (Long)objects[2];
            VariantType variantType = (VariantType)objects[0];
            results.put(variantType.getTypeName(), results.get(variantType.getTypeName()) + value);
            results.put((String)objects[1], value);
        }
        return results;
    }

    public long getNumberOfPushApplicationsForDeveloper(String name) {
        return (Long)this.createQuery("select count(pa) from PushApplication pa where pa.developer = :developer").setParameter("developer", (Object)name).getSingleResult();
    }

    public List<PushApplication> findByVariantIds(List<String> variantIDs) {
        String jpql = "select pa from PushApplication pa left join fetch pa.variants v where v.variantID in (:variantIDs)";
        return this.createQuery("select pa from PushApplication pa left join fetch pa.variants v where v.variantID in (:variantIDs)").setParameter("variantIDs", variantIDs).getResultList();
    }

    public PushApplication find(String id) {
        return (PushApplication)this.entityManager.find(PushApplication.class, (Object)id);
    }

    private PushApplication getSingleResultForQuery(Query query) {
        List result = query.getResultList();
        if (!result.isEmpty()) {
            return (PushApplication)result.get(0);
        }
        return null;
    }

    public PageResult<PushApplication> findAll(Integer page, Integer pageSize) {
        String select = "from PushApplication pa";
        Long count = (Long)this.entityManager.createQuery("select count(*) " + select, Long.class).getSingleResult();
        List entities = this.entityManager.createQuery("select pa " + select, PushApplication.class).setFirstResult(page * pageSize).setMaxResults(pageSize.intValue()).getResultList();
        return new PageResult(entities, count.longValue());
    }

    public PushApplication findAllByPushApplicationID(String pushApplicationID) {
        return this.getSingleResultForQuery(this.createQuery("select pa from PushApplication pa where pa.pushApplicationID = :pushApplicationID").setParameter("pushApplicationID", (Object)pushApplicationID));
    }

    public long getNumberOfPushApplicationsForDeveloper() {
        return (Long)this.createQuery("select count(pa) from PushApplication pa").getSingleResult();
    }
}

