/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.jboss.aerogear.unifiedpush.api.PushMessageInformation;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dao.PushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.dto.MessageMetrics;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAPushMessageInformationDao
extends JPABaseDao<PushMessageInformation, String>
implements PushMessageInformationDao {
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private final Logger logger = LoggerFactory.getLogger(JPAPushMessageInformationDao.class);

    public List<PushMessageInformation> findAllForPushApplication(String pushApplicationId, boolean ascending) {
        return this.createQuery("select pmi from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending)).setParameter("pushApplicationId", (Object)pushApplicationId).getResultList();
    }

    public long getNumberOfPushMessagesForPushApplication(String pushApplicationId) {
        return (Long)this.createQuery("select count(*) from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId", Long.class).setParameter("pushApplicationId", (Object)pushApplicationId).getSingleResult();
    }

    public long getNumberOfPushMessagesForVariant(String variantID) {
        return (Long)this.createQuery("select count(*) from VariantMetricInformation vmi where vmi.variantID = :variantID", Long.class).setParameter("variantID", (Object)variantID).getSingleResult();
    }

    public PageResult<PushMessageInformation, MessageMetrics> findAllForPushApplication(String pushApplicationId, String search, boolean ascending, Integer page, Integer pageSize) {
        String baseQuery = "from PushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId";
        if (search != null) {
            baseQuery = baseQuery + " AND pmi.rawJsonMessage LIKE :search";
        }
        String queryJPQL = "select pmi " + baseQuery + " ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        String metricsJPQL = "select new org.jboss.aerogear.unifiedpush.dto.MessageMetrics(count(*), sum(totalReceivers), sum(appOpenCounter)) " + baseQuery;
        TypedQuery typedQuery = this.createQuery(queryJPQL).setParameter("pushApplicationId", (Object)pushApplicationId);
        if (search != null) {
            typedQuery.setParameter("search", (Object)("%" + search + "%"));
        }
        typedQuery.setFirstResult(page * pageSize).setMaxResults(pageSize.intValue());
        List pushMessageInformationList = typedQuery.getResultList();
        Query metricsQuery = this.createUntypedQuery(metricsJPQL).setParameter("pushApplicationId", (Object)pushApplicationId);
        if (search != null) {
            metricsQuery.setParameter("search", (Object)("%" + search + "%"));
        }
        MessageMetrics messageMetrics = (MessageMetrics)metricsQuery.getSingleResult();
        return new PageResult(pushMessageInformationList, (Object)messageMetrics);
    }

    public long getNumberOfPushMessagesForLoginName(String loginName) {
        return (Long)this.createQuery("select count(pmi) from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p where p.developer = :developer)", Long.class).setParameter("developer", (Object)loginName).getSingleResult();
    }

    public List<String> findVariantIDsWithWarnings(String loginName) {
        return this.createQuery("select distinct vmi.variantID from VariantMetricInformation vmi where vmi.variantID IN (select t.variantID from Variant t where t.developer = :developer) and vmi.deliveryStatus = false", String.class).setParameter("developer", (Object)loginName).getResultList();
    }

    public List<PushMessageInformation> findLatestActivity(String loginName, int maxResults) {
        return this.createQuery("select pmi from PushMessageInformation pmi where pmi.pushApplicationId IN (select p.pushApplicationID from PushApplication p where p.developer = :developer) ORDER BY pmi.submitDate DESC").setParameter("developer", (Object)loginName).setMaxResults(maxResults).getResultList();
    }

    public void deletePushInformationOlderThan(Date oldest) {
        this.entityManager.createQuery("delete from VariantMetricInformation vmi where vmi.pushMessageInformation.id in (select pmi FROM PushMessageInformation pmi WHERE pmi.submitDate < :oldest)").setParameter("oldest", (Object)oldest).executeUpdate();
        int affectedRows = this.entityManager.createQuery("delete FROM PushMessageInformation pmi WHERE pmi.submitDate < :oldest").setParameter("oldest", (Object)oldest).executeUpdate();
        this.logger.info("Deleting ['{}'] outdated PushMessageInformation objects", (Object)affectedRows);
    }

    public List<String> findVariantIDsWithWarnings() {
        return this.createQuery("select distinct vmi.variantID from VariantMetricInformation vmi where vmi.deliveryStatus = false", String.class).getResultList();
    }

    public List<PushMessageInformation> findLatestActivity(int maxResults) {
        return this.createQuery("select pmi from PushMessageInformation pmi ORDER BY pmi.submitDate DESC").setMaxResults(maxResults).getResultList();
    }

    public long getNumberOfPushMessagesForApplications() {
        return (Long)this.createQuery("select count(pmi) from PushMessageInformation pmi", Long.class).getSingleResult();
    }

    private String ascendingOrDescending(boolean asc) {
        if (asc) {
            return ASC;
        }
        return DESC;
    }

    @Override
    public Class<PushMessageInformation> getType() {
        return PushMessageInformation.class;
    }
}

