/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Collections;
import java.util.List;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.dao.VariantDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;

public class JPAVariantDao
extends JPABaseDao<Variant, String>
implements VariantDao {
    @Override
    public void delete(Variant variant) {
        this.entityManager.createQuery("delete from Installation i where i.variant in :variant").setParameter("variant", (Object)variant).executeUpdate();
        this.entityManager.createQuery("delete from VariantErrorStatus ves where ves.variant in :variant").setParameter("variant", (Object)variant).executeUpdate();
        Variant entity = (Variant)this.find(variant.getId());
        super.delete(entity);
    }

    public Variant findByVariantID(String variantID) {
        return (Variant)this.getSingleResultForQuery(this.createQuery("select t from Variant t where t.variantID = :variantID").setParameter("variantID", (Object)variantID));
    }

    public boolean existsVariantIDForDeveloper(String variantID, String loginName) {
        Long numberOfVariants = (Long)this.createQuery("select count(t) from Variant t where t.variantID = :variantID and t.developer = :developer", Long.class).setParameter("variantID", (Object)variantID).setParameter("developer", (Object)loginName).getSingleResult();
        return numberOfVariants == 1L;
    }

    public List<String> findVariantIDsForDeveloper(String loginName) {
        return this.createQuery("select t.variantID from Variant t where t.developer = :developer", String.class).setParameter("developer", (Object)loginName).getResultList();
    }

    public List<Variant> findAllVariantsByIDs(List<String> variantIDs) {
        if (variantIDs.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createQuery("select t from Variant t where t.variantID IN :variantIDs").setParameter("variantIDs", variantIDs).getResultList();
    }

    public boolean existsVariantIDForAdmin(String variantID) {
        Long numberOfVariants = (Long)this.createQuery("select count(t) from Variant t where t.variantID = :variantID", Long.class).setParameter("variantID", (Object)variantID).getSingleResult();
        return numberOfVariants == 1L;
    }

    @Override
    public Class<Variant> getType() {
        return Variant.class;
    }
}

