/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.jboss.aerogear.unifiedpush.api.FlatPushMessageInformation;
import org.jboss.aerogear.unifiedpush.dao.FlatPushMessageInformationDao;
import org.jboss.aerogear.unifiedpush.dao.PageResult;
import org.jboss.aerogear.unifiedpush.dto.MessageMetrics;
import org.jboss.aerogear.unifiedpush.jpa.dao.impl.JPABaseDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAFlatPushMessageInformationDao
extends JPABaseDao<FlatPushMessageInformation, String>
implements FlatPushMessageInformationDao {
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private static final Logger logger = LoggerFactory.getLogger(JPAFlatPushMessageInformationDao.class);

    public List<FlatPushMessageInformation> findAllForPushApplication(String pushApplicationId, boolean ascending) {
        return this.findAllForPushApplicationByParams(pushApplicationId, null, ascending, null, null);
    }

    public List<FlatPushMessageInformation> findAllForPushApplicationByParams(String pushApplicationId, String search, boolean ascending, Integer page, Integer pageSize) {
        String baseQuery = "from FlatPushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId";
        if (search != null) {
            baseQuery = baseQuery + " AND pmi.rawJsonMessage LIKE :search";
        }
        String queryJPQL = "select pmi " + baseQuery + " ORDER BY pmi.submitDate " + this.ascendingOrDescending(ascending);
        TypedQuery typedQuery = this.createQuery(queryJPQL).setParameter("pushApplicationId", (Object)pushApplicationId);
        if (search != null) {
            typedQuery.setParameter("search", (Object)("%" + search + "%"));
        }
        if (pageSize != null) {
            typedQuery.setFirstResult(page * pageSize).setMaxResults(pageSize.intValue());
        }
        return typedQuery.getResultList();
    }

    public long getNumberOfPushMessagesForPushApplication(String pushApplicationId) {
        return (Long)this.createQuery("select count(*) from FlatPushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId", Long.class).setParameter("pushApplicationId", (Object)pushApplicationId).getSingleResult();
    }

    public MessageMetrics findMessageMetricsForPushApplicationByParams(String pushApplicationId, String search, boolean ascending, Integer page, Integer pageSize) {
        String metricsJPQL = "select new org.jboss.aerogear.unifiedpush.dto.MessageMetrics(count(*), sum(appOpenCounter)) from FlatPushMessageInformation pmi where pmi.pushApplicationId = :pushApplicationId";
        if (search != null) {
            metricsJPQL = metricsJPQL + " AND pmi.rawJsonMessage LIKE :search";
        }
        Query metricsQuery = this.createUntypedQuery(metricsJPQL).setParameter("pushApplicationId", (Object)pushApplicationId);
        if (search != null) {
            metricsQuery.setParameter("search", (Object)("%" + search + "%"));
        }
        return (MessageMetrics)metricsQuery.getSingleResult();
    }

    public PageResult<FlatPushMessageInformation, MessageMetrics> findAllForPushApplication(String pushApplicationId, String search, boolean ascending, Integer page, Integer pageSize) {
        List<FlatPushMessageInformation> pushMessageInformationList = this.findAllForPushApplicationByParams(pushApplicationId, search, ascending, page, pageSize);
        MessageMetrics messageMetrics = this.findMessageMetricsForPushApplicationByParams(pushApplicationId, search, ascending, page, pageSize);
        return new PageResult(pushMessageInformationList, (Object)messageMetrics);
    }

    public long getNumberOfPushMessagesForLoginName(String loginName) {
        return (Long)this.createQuery("select count(pmi) from FlatPushMessageInformation pmi, PushApplication pa where pmi.pushApplicationId = pa.pushApplicationID and pa.developer = :developer)", Long.class).setParameter("developer", (Object)loginName).getSingleResult();
    }

    public List<String> findVariantIDsWithWarnings(String loginName) {
        return this.createQuery("select distinct vmi.variantID from VariantErrorStatus vmi  WHERE vmi.variant.developer = :developer)", String.class).setParameter("developer", (Object)loginName).getResultList();
    }

    public List<FlatPushMessageInformation> findLatestActivity(String loginName, int maxResults) {
        return this.createQuery("select pmi from FlatPushMessageInformation pmi, PushApplication pa WHERE pmi.pushApplicationId = pa.pushApplicationID AND pa.developer = :developer) ORDER BY pmi.submitDate DESC").setParameter("developer", (Object)loginName).setMaxResults(maxResults).getResultList();
    }

    public void deletePushInformationOlderThan(Date oldest) {
        this.entityManager.createQuery("delete from VariantErrorStatus vmi where vmi.pushMessageInformation.id in (select pmi FROM FlatPushMessageInformation pmi WHERE pmi.submitDate < :oldest)").setParameter("oldest", (Object)oldest).executeUpdate();
        int affectedRows = this.entityManager.createQuery("delete FROM FlatPushMessageInformation pmi WHERE pmi.submitDate < :oldest").setParameter("oldest", (Object)oldest).executeUpdate();
        logger.info("Deleting ['" + affectedRows + "'] outdated FlatPushMessageInformation objects");
    }

    public List<String> findVariantIDsWithWarnings() {
        return this.createQuery("select distinct vmi.variantID from VariantErrorStatus vmi", String.class).getResultList();
    }

    public List<FlatPushMessageInformation> findLatestActivity(int maxResults) {
        return this.createQuery("select pmi from FlatPushMessageInformation pmi ORDER BY pmi.submitDate DESC").setMaxResults(maxResults).getResultList();
    }

    public long getNumberOfPushMessagesForApplications() {
        return (Long)this.createQuery("select count(pmi) from FlatPushMessageInformation pmi", Long.class).getSingleResult();
    }

    private String ascendingOrDescending(boolean asc) {
        if (asc) {
            return ASC;
        }
        return DESC;
    }

    @Override
    public Class<FlatPushMessageInformation> getType() {
        return FlatPushMessageInformation.class;
    }
}

