/**
 * JBoss, Home of Professional Open Source
 * Copyright Red Hat, Inc., and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.aerogear.unifiedpush.message.windows;

/**
 * Different type of tile messages with different sizes
 * See the <a href="https://msdn.microsoft.com/en-us/library/windows/apps/hh761491.aspx">tile template catalog</a>
 */
public enum TileType {
    TileSquareBlock,
    TileSquareText01,
    TileSquareText02,
    TileSquareText03,
    TileSquareText04,

    TileSquareImage,

    TileSquarePeekImageAndText01,
    TileSquarePeekImageAndText02,
    TileSquarePeekImageAndText03,
    TileSquarePeekImageAndText04,

    TileWideText01,
    TileWideText02,
    TileWideText03,
    TileWideText04,
    TileWideText05,
    TileWideText06,
    TileWideText07,
    TileWideText08,
    TileWideText09,
    TileWideText10,
    TileWideText11,

    TileWideImage,
    TileWideImageCollection,

    TileWideImageAndText01,
    TileWideImageAndText02,
    TileWideBlockAndText01,
    TileWideBlockAndText02,
    TileWideSmallImageAndText01,
    TileWideSmallImageAndText02,
    TileWideSmallImageAndText03,
    TileWideSmallImageAndText04,
    TileWideSmallImageAndText05,

    TileWidePeekImageCollection01,
    TileWidePeekImageCollection02,
    TileWidePeekImageCollection03,
    TileWidePeekImageCollection04,
    TileWidePeekImageCollection05,
    TileWidePeekImageCollection06,
    TileWidePeekImageAndText01,
    TileWidePeekImageAndText02,
    TileWidePeekImage01,
    TileWidePeekImage02,
    TileWidePeekImage03,
    TileWidePeekImage04,
    TileWidePeekImage05,
    TileWidePeekImage06
}
