/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.jpa.dao.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.jboss.aerogear.unifiedpush.jpa.AbstractGenericDao;
import org.jboss.aerogear.unifiedpush.jpa.dao.InstallationDao;
import org.jboss.aerogear.unifiedpush.model.AbstractVariant;
import org.jboss.aerogear.unifiedpush.model.InstallationImpl;

public class InstallationDaoImpl
extends AbstractGenericDao<InstallationImpl, String>
implements InstallationDao {
    public InstallationImpl findInstallationForVariantByDeviceToken(String variantID, String deviceToken) {
        return (InstallationImpl)this.getSingleResultForQuery(this.createQuery("select installation from " + AbstractVariant.class.getSimpleName() + " abstractVariant join abstractVariant.installations installation" + " where abstractVariant.variantID = :variantID" + " and installation.deviceToken = :deviceToken").setParameter("variantID", (Object)variantID).setParameter("deviceToken", (Object)deviceToken));
    }

    public List<InstallationImpl> findInstallationsForVariantByDeviceTokens(String variantID, Set<String> deviceTokens) {
        if (deviceTokens == null || deviceTokens.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.createQuery("select installation from " + AbstractVariant.class.getSimpleName() + " abstractVariant join abstractVariant.installations installation" + " where abstractVariant.variantID = :variantID" + " and installation.deviceToken IN :deviceTokens").setParameter("variantID", (Object)variantID).setParameter("deviceTokens", deviceTokens).getResultList();
    }

    public List<String> findAllPushEndpointURLsForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        StringBuilder jpqlString = new StringBuilder("select installation.simplePushEndpoint from ");
        jpqlString.append(AbstractVariant.class.getSimpleName()).append(" abstractVariant join abstractVariant.installations installation where abstractVariant.variantID = :variantID AND installation.enabled = true");
        return this.executeDynamicQuery(jpqlString, variantID, categories, aliases, deviceTypes);
    }

    public List<String> findAllDeviceTokenForVariantIDByCriteria(String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        StringBuilder jpqlString = new StringBuilder("select installation.deviceToken from ");
        jpqlString.append(AbstractVariant.class.getSimpleName()).append(" abstractVariant join abstractVariant.installations installation where abstractVariant.variantID = :variantID AND installation.enabled = true");
        return this.executeDynamicQuery(jpqlString, variantID, categories, aliases, deviceTypes);
    }

    private List<String> executeDynamicQuery(StringBuilder jpqlBaseString, String variantID, List<String> categories, List<String> aliases, List<String> deviceTypes) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (this.isListEmpty(aliases)) {
            jpqlBaseString.append(" and installation.alias IN :aliases");
            parameters.put("aliases", aliases);
        }
        if (this.isListEmpty(deviceTypes)) {
            jpqlBaseString.append(" and installation.deviceType IN :deviceTypes");
            parameters.put("deviceTypes", deviceTypes);
        }
        if (this.isListEmpty(categories)) {
            for (int i = 0; i < categories.size(); ++i) {
                if (i == 0) {
                    jpqlBaseString.append(" and ( :categories" + i + " IN ELEMENTS(installation.categories)");
                } else {
                    jpqlBaseString.append(" OR :categories" + i + " IN ELEMENTS(installation.categories)");
                }
                parameters.put("categories" + i, categories.get(i));
            }
            jpqlBaseString.append(')');
        }
        Query jpql = this.createQuery(jpqlBaseString.toString());
        jpql.setParameter("variantID", (Object)variantID);
        Set paramKeys = parameters.keySet();
        for (String parameterName : paramKeys) {
            jpql.setParameter(parameterName, parameters.get(parameterName));
        }
        return jpql.getResultList();
    }

    private boolean isListEmpty(List list) {
        return list != null && !list.isEmpty();
    }
}

