/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.cache;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aerogear.unifiedpush.model.iOSVariant;

public class APNsCache
implements Serializable {
    private static final long serialVersionUID = -1913999384798892563L;
    private final ConcurrentHashMap<String, ApnsService> apnsCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApnsService getApnsServiceForVariant(iOSVariant iOSVariant2) {
        ApnsService variantService = null;
        ConcurrentHashMap concurrentHashMap = this.apnsCache;
        synchronized (concurrentHashMap) {
            String variantId = iOSVariant2.getId();
            variantService = (ApnsService)this.apnsCache.get(variantId);
            if (variantService == null) {
                variantService = APNS.newService().withCert((InputStream)new ByteArrayInputStream(iOSVariant2.getCertificate()), iOSVariant2.getPassphrase()).withSandboxDestination().asQueued().build();
                this.apnsCache.put(variantId, variantService);
            }
        }
        return variantService;
    }
}

