/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsService;
import com.notnoop.apns.ApnsServiceBuilder;
import com.notnoop.apns.PayloadBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.aerogear.unifiedpush.model.iOSVariant;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.sender.message.UnifiedPushMessage;

public class APNsPushNotificationSender {
    private final Logger logger = Logger.getLogger(APNsPushNotificationSender.class.getName());
    @Inject
    private ClientInstallationService clientInstallationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPushMessage(iOSVariant iOSVariant2, Collection<String> tokens, UnifiedPushMessage pushMessage) {
        if (tokens.isEmpty()) {
            return;
        }
        PayloadBuilder builder = APNS.newPayload().alertBody(pushMessage.getAlert()).badge(pushMessage.getBadge()).sound(pushMessage.getSound());
        if (pushMessage.isContentAvailable()) {
            builder = builder.forNewsstand();
        }
        builder = builder.customFields(pushMessage.getData());
        String apnsMessage = builder.build();
        ApnsService service = this.buildApnsService(iOSVariant2);
        if (service != null) {
            try {
                this.logger.fine(String.format("Sending transformed APNs payload: '%s' ", apnsMessage));
                service.start();
                Date expireDate = this.createFutureDateBasedOnTTL(pushMessage.getTimeToLive());
                service.push(tokens, apnsMessage, expireDate);
                Set inactiveTokens = service.getInactiveDevices().keySet();
                Set transformedTokens = this.lowerCaseAllTokens(inactiveTokens);
                this.clientInstallationService.removeInstallationsForVariantByDeviceTokens(iOSVariant2.getVariantID(), transformedTokens);
            }
            catch (RuntimeException e) {
                this.logger.log(Level.SEVERE, "Error sending messages to APN server", e);
            }
            finally {
                service.stop();
            }
        } else {
            this.logger.severe("No certificate was found. Could not send messages to APNs");
        }
    }

    private Date createFutureDateBasedOnTTL(int ttl) {
        if (ttl == -1) {
            return new Date(System.currentTimeMillis() + 2147483647000L);
        }
        return new Date(System.currentTimeMillis() + (long)ttl);
    }

    private Set<String> lowerCaseAllTokens(Set<String> inactiveTokens) {
        HashSet<String> lowerCaseTokens = new HashSet<String>();
        for (String token : inactiveTokens) {
            lowerCaseTokens.add(token.toLowerCase());
        }
        return lowerCaseTokens;
    }

    private ApnsService buildApnsService(iOSVariant iOSVariant2) {
        if (iOSVariant2.getCertificate() != null && iOSVariant2.getPassphrase() != null) {
            ApnsServiceBuilder builder = APNS.newService();
            ByteArrayInputStream stream = new ByteArrayInputStream(iOSVariant2.getCertificate());
            builder.withCert((InputStream)stream, iOSVariant2.getPassphrase());
            try {
                stream.close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error reading certificate", e);
            }
            if (iOSVariant2.isProduction()) {
                builder.withProductionDestination();
            } else {
                builder.withSandboxDestination();
            }
            return builder.build();
        }
        return null;
    }
}

