/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message.sender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.core.Response;

@ApplicationScoped
public class SimplePushNotificationSender
implements Serializable {
    private static final long serialVersionUID = 5747687132270998712L;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Logger logger = Logger.getLogger(SimplePushNotificationSender.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(List<String> pushEndpointURLs, String payload) {
        for (String clientURL : pushEndpointURLs) {
            HttpURLConnection conn = null;
            try {
                this.logger.fine(String.format("Sending transformed SimplePush version: '%s' to %s", payload, clientURL));
                conn = this.put(clientURL, payload);
                int simplePushStatusCode = conn.getResponseCode();
                this.logger.info("SimplePush Status: " + simplePushStatusCode);
                if (Response.Status.OK.getStatusCode() == simplePushStatusCode) continue;
                this.logger.severe("ERROR ??????     STATUS CODE, from PUSH NETWORK was NOT 200, but....: " + simplePushStatusCode);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error during PUT execution to SimplePush Network", e);
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpURLConnection put(String url, String body) throws IOException {
        if (url == null || body == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        byte[] bytes = body.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Accept", "application/x-www-form-urlencoded");
        conn.setRequestMethod("PUT");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }
}

