/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.model;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.validation.constraints.Size;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.jpa.PersistentObject;
import org.jboss.aerogear.unifiedpush.model.InstallationImpl;

@Entity
@DiscriminatorColumn(name="TYPE", discriminatorType=DiscriminatorType.STRING)
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class AbstractVariant
extends PersistentObject
implements Variant {
    private static final long serialVersionUID = -5028062942838899201L;
    @Column
    @Size(min=1, max=255)
    private String name;
    @Column
    @Size(min=0, max=255)
    private String description;
    @Column
    private String variantID = UUID.randomUUID().toString();
    @Column
    private String secret = UUID.randomUUID().toString();
    @Column
    private String developer;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.REMOVE})
    @JoinColumn(name="variantID", referencedColumnName="variantID")
    private Set<InstallationImpl> installations = new HashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<InstallationImpl> getInstallations() {
        return this.installations;
    }

    public void setInstallations(Set<InstallationImpl> installations) {
        this.installations = installations;
    }

    public String getVariantID() {
        return this.variantID;
    }

    public void setVariantID(String variantID) {
        this.variantID = variantID;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getDeveloper() {
        return this.developer;
    }

    public void setDeveloper(String developer) {
        this.developer = developer;
    }
}

