/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.security.authz.Secure;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.model.AndroidVariant;
import org.jboss.aerogear.unifiedpush.model.PushApplication;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;

@Stateless
@TransactionAttribute
@Path(value="/applications/{pushAppID}/android")
@Secure(value={"developer", "admin"})
public class AndroidVariantEndpoint
extends AbstractVariantEndpoint {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerAndroidVariant(AndroidVariant androidVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get());
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplication").build();
        }
        try {
            this.validateModelClass((Object)androidVariant);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        androidVariant.setDeveloper((String)this.loginName.get());
        androidVariant = (AndroidVariant)this.variantService.addVariant((Variant)androidVariant);
        this.pushAppService.addAndroidVariant(pushApp, androidVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(androidVariant.getVariantID())).build(new Object[0])).entity((Object)androidVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllAndroidVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        return Response.ok((Object)this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get()).getAndroidVariants()).build();
    }

    @PUT
    @Path(value="/{androidID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAndroidVariation(@PathParam(value="pushAppID") String id, @PathParam(value="androidID") String androidID, AndroidVariant updatedAndroidApplication) {
        AndroidVariant androidVariant = (AndroidVariant)this.variantService.findByVariantIDForDeveloper(androidID, (String)this.loginName.get());
        if (androidVariant != null) {
            try {
                this.validateModelClass((Object)updatedAndroidApplication);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            androidVariant.setGoogleKey(updatedAndroidApplication.getGoogleKey());
            androidVariant.setProjectNumber(updatedAndroidApplication.getProjectNumber());
            androidVariant.setName(updatedAndroidApplication.getName());
            androidVariant.setDescription(updatedAndroidApplication.getDescription());
            this.variantService.updateVariant((Variant)androidVariant);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

