/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.security.auth.LoggedUser;
import org.jboss.aerogear.security.authz.Secure;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.model.InstallationImpl;
import org.jboss.aerogear.unifiedpush.service.ClientInstallationService;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;

@Stateless
@TransactionAttribute
@Path(value="/applications/{variantID}/installations/")
@Secure(value={"developer", "admin"})
public class InstallationManagementEndpoint {
    @Inject
    private GenericVariantService genericVariantService;
    @Inject
    private ClientInstallationService clientInstallationService;
    @Inject
    @LoggedUser
    private Instance<String> loginName;

    @GET
    @Produces(value={"application/json"})
    public Response findInstallations(@PathParam(value="variantID") String variantId) {
        Variant variant = this.genericVariantService.findByVariantIDForDeveloper(variantId, (String)this.loginName.get());
        if (variant == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
        }
        return Response.ok((Object)variant.getInstallations()).build();
    }

    @GET
    @Path(value="/{installationID}")
    @Produces(value={"application/json"})
    public Response findInstallation(@PathParam(value="variantID") String variantId, @PathParam(value="installationID") String installationId) {
        InstallationImpl installation = this.clientInstallationService.findById(installationId);
        if (installation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Installation").build();
        }
        return Response.ok((Object)installation).build();
    }

    @PUT
    @Path(value="/{installationID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateInstallation(InstallationImpl entity, @PathParam(value="variantID") String variantId, @PathParam(value="installationID") String installationId) {
        InstallationImpl installation = this.clientInstallationService.findById(installationId);
        if (installation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Installation").build();
        }
        this.clientInstallationService.updateInstallation(installation, entity);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{installationID}")
    @Produces(value={"application/json"})
    public Response removeInstallation(@PathParam(value="variantID") String variantId, @PathParam(value="installationID") String installationId) {
        InstallationImpl installation = this.clientInstallationService.findById(installationId);
        if (installation == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Installation").build();
        }
        this.clientInstallationService.removeInstallation(installation);
        return Response.noContent().build();
    }
}

