/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import java.util.UUID;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.aerogear.security.auth.LoggedUser;
import org.jboss.aerogear.security.authz.Secure;
import org.jboss.aerogear.unifiedpush.model.PushApplication;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;

@Stateless
@TransactionAttribute
@Path(value="/applications")
@Secure(value={"developer", "admin"})
public class PushApplicationEndpoint
extends AbstractBaseEndpoint {
    @Inject
    private PushApplicationService pushAppService;
    @Inject
    @LoggedUser
    private Instance<String> loginName;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerPushApplication(PushApplication pushApp) {
        try {
            this.validateModelClass((Object)pushApp);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        pushApp.setDeveloper((String)this.loginName.get());
        this.pushAppService.addPushApplication(pushApp);
        return Response.created((URI)UriBuilder.fromResource(PushApplicationEndpoint.class).path(String.valueOf(pushApp.getPushApplicationID())).build(new Object[0])).entity((Object)pushApp).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllPushApplications() {
        return Response.ok((Object)this.pushAppService.findAllPushApplicationsForDeveloper((String)this.loginName.get())).build();
    }

    @GET
    @Path(value="/{pushAppID}")
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get());
        if (pushApp != null) {
            return Response.ok((Object)pushApp).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplication").build();
    }

    @PUT
    @Path(value="/{pushAppID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePushApplication(@PathParam(value="pushAppID") String pushApplicationID, PushApplication updatedPushApp) {
        PushApplication pushApp = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get());
        if (pushApp != null) {
            try {
                this.validateModelClass((Object)pushApp);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            pushApp.setDescription(updatedPushApp.getDescription());
            pushApp.setName(updatedPushApp.getName());
            this.pushAppService.updatePushApplication(pushApp);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplication").build();
    }

    @PUT
    @Path(value="/{pushAppID}/reset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetMasterSecret(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get());
        if (pushApp != null) {
            String newMasterSecret = UUID.randomUUID().toString();
            pushApp.setMasterSecret(newMasterSecret);
            this.pushAppService.updatePushApplication(pushApp);
            return Response.ok((Object)pushApp).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplication").build();
    }

    @DELETE
    @Path(value="/{pushAppID}")
    @Produces(value={"application/json"})
    public Response deletePushApplication(@PathParam(value="pushAppID") String pushApplicationID) {
        PushApplication pushApp = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get());
        if (pushApp != null) {
            this.pushAppService.removePushApplication(pushApp);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplication").build();
    }
}

