/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.net.URI;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.aerogear.security.authz.Secure;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.model.PushApplication;
import org.jboss.aerogear.unifiedpush.model.SimplePushVariant;
import org.jboss.aerogear.unifiedpush.rest.registry.applications.AbstractVariantEndpoint;

@Stateless
@TransactionAttribute
@Path(value="/applications/{pushAppID}/simplePush")
@Secure(value={"developer", "admin"})
public class SimplePushVariantEndpoint
extends AbstractVariantEndpoint {
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response registerSimplePushVariant(SimplePushVariant simplePushVariant, @PathParam(value="pushAppID") String pushApplicationID, @Context UriInfo uriInfo) {
        PushApplication pushApp = this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get());
        if (pushApp == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested PushApplication").build();
        }
        try {
            this.validateModelClass((Object)simplePushVariant);
        }
        catch (ConstraintViolationException cve) {
            Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
            return builder.build();
        }
        simplePushVariant.setDeveloper((String)this.loginName.get());
        simplePushVariant = (SimplePushVariant)this.variantService.addVariant((Variant)simplePushVariant);
        this.pushAppService.addSimplePushVariant(pushApp, simplePushVariant);
        return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(String.valueOf(simplePushVariant.getVariantID())).build(new Object[0])).entity((Object)simplePushVariant).build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listAllSimplePushVariationsForPushApp(@PathParam(value="pushAppID") String pushApplicationID) {
        return Response.ok((Object)this.pushAppService.findByPushApplicationIDForDeveloper(pushApplicationID, (String)this.loginName.get()).getSimplePushVariants()).build();
    }

    @PUT
    @Path(value="/{simplePushID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateSimplePushVariation(@PathParam(value="pushAppID") String id, @PathParam(value="simplePushID") String simplePushID, SimplePushVariant updatedSimplePushApplication) {
        SimplePushVariant spVariant = (SimplePushVariant)this.variantService.findByVariantIDForDeveloper(simplePushID, (String)this.loginName.get());
        if (spVariant != null) {
            try {
                this.validateModelClass((Object)updatedSimplePushApplication);
            }
            catch (ConstraintViolationException cve) {
                Response.ResponseBuilder builder = this.createBadRequestResponse(cve.getConstraintViolations());
                return builder.build();
            }
            spVariant.setName(updatedSimplePushApplication.getName());
            spVariant.setDescription(updatedSimplePushApplication.getDescription());
            this.variantService.updateVariant((Variant)spVariant);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

