/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.security;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.security.authz.Secure;
import org.jboss.aerogear.unifiedpush.users.Developer;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;

@Stateless
@Path(value="/auth")
public class AdminEndpoint {
    @Inject
    private PartitionManager partitionManager;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;

    @POST
    @Path(value="/enroll")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secure(value={"admin"})
    public Response enroll(Developer developer) {
        try {
            this.identityManager = this.partitionManager.createIdentityManager();
            this.relationshipManager = this.partitionManager.createRelationshipManager();
            User user = new User(developer.getLoginName());
            this.identityManager.add((IdentityType)user);
            Calendar calendar = this.expirationDate();
            Password password = new Password(developer.getPassword().toCharArray());
            this.identityManager.updateCredential((Account)user, (Object)password, new Date(), calendar.getTime());
            Role developerRole = BasicModel.getRole((IdentityManager)this.identityManager, (String)"developer");
            this.grantRoles(user, developerRole);
            List list = this.identityManager.createIdentityQuery(User.class).setParameter(User.LOGIN_NAME, new Object[]{user.getLoginName()}).getResultList();
            user = (User)list.get(0);
            developer.setId(user.getId());
        }
        catch (IdentityManagementException ime) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Credential not available").build();
        }
        return Response.ok((Object)developer).build();
    }

    private void grantRoles(User user, Role role) {
        BasicModel.grantRole((RelationshipManager)this.relationshipManager, (IdentityType)user, (Role)role);
    }

    private Calendar expirationDate() {
        int EXPIRATION_TIME = -5;
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(12, EXPIRATION_TIME);
        return expirationDate;
    }
}

