/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.security;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.security.auth.AuthenticationManager;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.exception.AeroGearSecurityException;
import org.jboss.aerogear.unifiedpush.users.Developer;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.User;

@Stateless
@Path(value="/auth")
public class AuthenticationEndpoint {
    @Inject
    private AuthenticationManager<Agent> authenticationManager;
    @Inject
    private IdentityManagement<User> configuration;

    @POST
    @Path(value="/login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response login(Developer developer) {
        this.authenticationManager.login((Object)developer, developer.getPassword());
        return Response.ok().build();
    }

    @POST
    @Path(value="/logout")
    public Response logout() {
        try {
            this.authenticationManager.logout();
        }
        catch (AeroGearSecurityException agse) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/update")
    public Response updateUserPasswordAndRole(Developer developer) {
        User simpleUser = (User)this.configuration.findByUsername(developer.getLoginName());
        this.configuration.reset((Object)simpleUser, developer.getPassword(), developer.getNewPassword());
        return Response.ok().build();
    }
}

