/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.sender;

import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.model.PushApplication;
import org.jboss.aerogear.unifiedpush.rest.security.util.HttpBasicHelper;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;
import org.jboss.aerogear.unifiedpush.service.sender.SenderService;
import org.jboss.aerogear.unifiedpush.service.sender.message.UnifiedPushMessage;

@Stateless
@Path(value="/sender")
@TransactionAttribute
public class PushNotificationSenderEndpoint {
    private final Logger logger = Logger.getLogger(PushNotificationSenderEndpoint.class.getName());
    @Inject
    private PushApplicationService pushApplicationService;
    @Inject
    private SenderService senderService;

    @POST
    @Consumes(value={"application/json"})
    public Response send(Map<String, Object> message, @Context HttpServletRequest request) {
        PushApplication pushApplication = this.loadPushApplicationWhenAuthorized(request);
        if (pushApplication == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"AeroGear UnifiedPush Server\"").entity((Object)"Unauthorized Request").build();
        }
        UnifiedPushMessage payload = new UnifiedPushMessage(message);
        this.senderService.send(pushApplication, payload);
        this.logger.info("Message submitted to PushNetworks for further processing");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Job submitted").build();
    }

    private PushApplication loadPushApplicationWhenAuthorized(HttpServletRequest request) {
        String[] credentials = HttpBasicHelper.extractUsernameAndPasswordFromBasicHeader((HttpServletRequest)request);
        String pushApplicationID = credentials[0];
        String secret = credentials[1];
        PushApplication pushApplication = this.pushApplicationService.findByPushApplicationID(pushApplicationID);
        if (pushApplication != null && pushApplication.getMasterSecret().equals(secret)) {
            return pushApplication;
        }
        return null;
    }
}

