/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.user;

import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.security.authz.Secure;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.IdentityQuery;

@Stateless
@TransactionAttribute
@Path(value="/users")
@Secure(value={"admin"})
public class UserEndpoint {
    @Inject
    private IdentityManager identityManager;

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        User developer = (User)this.identityManager.lookupIdentityById(User.class, id);
        if (developer == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)developer).build();
    }

    @GET
    @Produces(value={"application/json"})
    public List<User> listAll() {
        IdentityQuery identityQuery = this.identityManager.createIdentityQuery(User.class);
        return identityQuery.getResultList();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(User developer) {
        this.identityManager.update((IdentityType)developer);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteById(@PathParam(value="id") String id) {
        User simpleUser = (User)this.identityManager.lookupIdentityById(User.class, id);
        this.identityManager.remove((IdentityType)simpleUser);
        return Response.noContent().build();
    }
}

